package com.segway.robot.sdk.voice.internal;

import android.util.SparseArray;

import com.segway.robot.sdk.voice.grammar.GrammarConstraint;
import com.segway.robot.sdk.voice.recognition.IRecognitionListener;
import com.segway.robot.sdk.voice.recognition.IWakeupListener;
import com.segway.robot.sdk.voice.recognition.RecognitionListener;
import com.segway.robot.sdk.voice.recognition.WakeupListener;

import java.util.HashMap;

/**
 * Created by ark338 on 16/9/1.
 */
public class Client {
    int mUid;
    final HashMap<String, GrammarConstraint> mGrammarConstraintMap;
    IWakeupListener mWakeupListener;
    IRecognitionListener mRecognitionListener;

    public Client(int uid) {
        mUid = uid;
        mGrammarConstraintMap = new HashMap<>();
    }

    public int getUid() {
        return mUid;
    }

    public void addGrammarConstraint(GrammarConstraint grammarConstraint) {
        synchronized (mGrammarConstraintMap) {
            mGrammarConstraintMap.put(grammarConstraint.getName(), grammarConstraint);
        }
    }

    public void removeGrammarConstraint(GrammarConstraint grammarConstraint) {
        synchronized (mGrammarConstraintMap) {
            mGrammarConstraintMap.remove(grammarConstraint.getName());
        }
    }

    public GrammarConstraint[] getGrammarConstraints() {
        return (GrammarConstraint[]) mGrammarConstraintMap.values().toArray();
    }

    public IWakeupListener getWakeupListener() {
        return mWakeupListener;
    }

    public void setWakeupListener(IWakeupListener wakeupListener) {
        mWakeupListener = wakeupListener;
    }

    public IRecognitionListener getRecognitionListener() {
        return mRecognitionListener;
    }

    public void setRecognitionListener(IRecognitionListener recognitionListener) {
        mRecognitionListener = recognitionListener;
    }
}
