package com.segway.robot.sdk.voice;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

class GrammarJsonValidator {

    GrammarJsonValidator() {
    }

    boolean validate(String input) {
        input = input.trim();
        return valid(input);
    }

    private boolean valid(String input) {
        if ("".equals(input)) return true;

        boolean ret = true;
        CharacterIterator it = new StringCharacterIterator(input);
        it.first();
        if (!value(it)) {
            ret = false;
        } else {
            skipWhiteSpace(it);
            if (it.current() != CharacterIterator.DONE) {
                ret = false;
            }
        }
        return ret;
    }

    private boolean value(CharacterIterator it) {
        return literal("true", it) || literal("false", it) || string(it) || object(it) || array(it);
    }

    private boolean literal(String text, CharacterIterator it) {
        CharacterIterator ci = new StringCharacterIterator(text);
        char t = ci.first();
        if (it.current() != t) return false;

        boolean ret = true;
        for (t = ci.next(); t != CharacterIterator.DONE; t = ci.next()) {
            if (t != nextCharacter(it)) {
                ret = false;
                break;
            }
        }
        nextCharacter(it);
        if (!ret) ret = false;
        return ret;
    }

    private boolean array(CharacterIterator it) {
        return aggregate('[', ']', false, it);
    }

    private boolean object(CharacterIterator it) {
        return aggregate('{', '}', true, it);
    }

    private boolean aggregate(char entryCharacter, char exitCharacter, boolean prefix, CharacterIterator it) {
        if (it.current() != entryCharacter) return false;
        nextCharacter(it);
        skipWhiteSpace(it);
        if (it.current() == exitCharacter) {
            nextCharacter(it);
            return true;
        }

        for (; ; ) {
            if (prefix) {
                if (!string(it)) return false;
                skipWhiteSpace(it);
                if (it.current() != ':') return false;
                nextCharacter(it);
                skipWhiteSpace(it);
            }
            if (value(it)) {
                skipWhiteSpace(it);
                if (it.current() == ',') {
                    nextCharacter(it);
                } else if (it.current() == exitCharacter) {
                    break;
                } else {
                    return false;
                }
            } else {
                return false;
            }
            skipWhiteSpace(it);
        }
        nextCharacter(it);
        return true;
    }

    private boolean string(CharacterIterator it) {
        if (it.current() != '"') return false;

        boolean escaped = false;
        for (nextCharacter(it); it.current() != CharacterIterator.DONE; nextCharacter(it)) {
            if (!escaped && it.current() == '\\') {
                escaped = true;
            } else if (escaped) {
                if (!escape(it)) {
                    return false;
                }
                escaped = false;
            } else if (it.current() == '"') {
                nextCharacter(it);
                return true;
            }
        }
        return false;
    }

    private boolean escape(CharacterIterator it) {
        if (" \\\"/bfnrtu".indexOf(it.current()) < 0) {
            return false;
        }
        if (it.current() == 'u') {
            if (!ishex(nextCharacter(it)) || !ishex(nextCharacter(it)) || !ishex(nextCharacter(it))
                    || !ishex(nextCharacter(it))) {
                return false;
            }
        }
        return true;
    }

    private boolean ishex(char d) {
        return "0123456789abcdefABCDEF".indexOf(d) >= 0;
    }

    private char nextCharacter(CharacterIterator it) {
        return it.next();
    }

    private void skipWhiteSpace(CharacterIterator it) {
        while (Character.isWhitespace(it.current())) {
            nextCharacter(it);
        }
    }
}