package com.segway.robot.sdk.voice.grammar;

/**
 * Listen to the results or errors from a grammar rebuilding started by
 * VoiceManager.rebuildGrammar(com.segway.robot.sdk.voice.grammar.RebuildGrammarListener).
 */
public interface RebuildGrammarListener {

    /**
     * This method is called when the grammar rebuilding completes successfully.
     */
    void onComplete();

    /**
     * A grammar format error or an internal error occurs.
     *
     * @param error the Error object that contains the details about what happens.
     */
    void onError(String error);
}
