/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.voice.grammar.Slot;
import java.util.List;

class CheckUtil {
    private static final String TAG = CheckUtil.class.getSimpleName();

    CheckUtil() {
    }

    public static boolean isEnChar(String chars) {
        StringBuilder illegalChars = new StringBuilder();
        int length = chars.length();
        for (int i = 0; i < length; ++i) {
            char item = chars.charAt(i);
            if ('a' <= item && 'z' >= item || 'A' <= item && 'Z' >= item || ' ' == item) continue;
            illegalChars.append("(").append(item).append(")");
        }
        if (illegalChars.length() != 0) {
            Logger.e((String)TAG, (String)("illegal char(chars): " + illegalChars.toString()));
            return false;
        }
        return true;
    }

    public static boolean isCnChar(String chars) {
        StringBuilder illegalChars = new StringBuilder();
        int length = chars.length();
        for (int i = 0; i < length; ++i) {
            char item = chars.charAt(i);
            if (item >= '\u4e00' && item <= '\u9fbb') continue;
            illegalChars.append("(").append(item).append(")");
        }
        if (illegalChars.length() != 0) {
            Logger.e((String)TAG, (String)("illegal char(chars): " + illegalChars.toString()));
            return false;
        }
        return true;
    }

    public static boolean isEnSlot(Slot slot) {
        if (slot == null) {
            throw new IllegalArgumentException("The slot can not be null!");
        }
        List<String> wordList = slot.getWordList();
        if (wordList.isEmpty()) {
            throw new IllegalArgumentException("The slot has no word!");
        }
        for (String word : wordList) {
            boolean en = CheckUtil.isEnChar(word);
            if (en) continue;
            return false;
        }
        return true;
    }

    public static boolean isCnSlot(Slot slot) {
        if (slot == null) {
            throw new IllegalArgumentException("The slot can not be null");
        }
        List<String> wordList = slot.getWordList();
        if (wordList.isEmpty()) {
            throw new IllegalArgumentException("The slot has no word");
        }
        for (String word : wordList) {
            boolean en = CheckUtil.isCnChar(word);
            if (en) continue;
            return false;
        }
        return true;
    }
}

