/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.base.version.VersionMismatchException;
import com.segway.robot.sdk.voice.ISpeaker;
import com.segway.robot.sdk.voice.VoiceException;
import com.segway.robot.sdk.voice.tts.ITtsListener;
import com.segway.robot.sdk.voice.tts.TtsListener;
import java.util.concurrent.atomic.AtomicBoolean;

class SpeakerManager
implements ServiceBinder {
    private static final String TAG = SpeakerManager.class.getSimpleName();
    private static final String SPEAKER_SERVICE_PACKAGE_NAME = "com.segway.robot.coreservice.voiceservice";
    private static final String SPEAKER_SERVICE_CLASS_NAME = "com.segway.robot.coreservice.voiceservice.TextToSpeechService";
    private ServiceBinder.BindStateListener mListener;
    ISpeaker mISpeaker;
    private Context mContext;
    private TtsListener mTtsListener;
    private boolean isBind = false;
    private boolean isSpeaking;
    private final AtomicBoolean mSpeakFinishLock = new AtomicBoolean(true);
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Logger.d((String)TAG, (String)"The service connected");
            SpeakerManager.this.mISpeaker = ISpeaker.Stub.asInterface(service);
            if (SpeakerManager.this.mISpeaker != null) {
                SpeakerManager.this.mListener.onBind();
            }
            try {
                Version serviceVersion = SpeakerManager.this.mISpeaker.getVersion();
                SpeakerManager.this.getVersion().check("VersionInfo", serviceVersion);
            }
            catch (RemoteException e) {
                String error = "Cannot get Speaker Service version, err = " + e.getMessage();
                SpeakerManager.this.mListener.onUnbind(error);
                SpeakerManager.this.mISpeaker = null;
                Logger.e((String)TAG, (String)error, (Throwable)e);
            }
            catch (VersionMismatchException e) {
                String error = "Version mismatch: " + e.getMessage();
                SpeakerManager.this.mListener.onUnbind(error);
                SpeakerManager.this.mISpeaker = null;
                Logger.e((String)TAG, (String)"Version mismatch", (Throwable)e);
                throw e;
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Logger.d((String)TAG, (String)"The service disconnected");
            SpeakerManager.this.isBind = false;
            SpeakerManager.this.mISpeaker = null;
            SpeakerManager.this.mListener.onUnbind("The service disconnected.");
        }
    };
    private ITtsListener.Stub mITtsListener = new ITtsListener.Stub(){

        @Override
        public void onSpeechStarted(String word) throws RemoteException {
            SpeakerManager.this.mTtsListener.onSpeechStarted(word);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSpeechFinished(String word) throws RemoteException {
            SpeakerManager.this.isSpeaking = false;
            SpeakerManager.this.mTtsListener.onSpeechFinished(word);
            AtomicBoolean atomicBoolean = SpeakerManager.this.mSpeakFinishLock;
            synchronized (atomicBoolean) {
                SpeakerManager.this.mSpeakFinishLock.set(true);
                SpeakerManager.this.mSpeakFinishLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSpeechError(String word, String reason) throws RemoteException {
            SpeakerManager.this.isSpeaking = false;
            SpeakerManager.this.mTtsListener.onSpeechError(word, reason);
            AtomicBoolean atomicBoolean = SpeakerManager.this.mSpeakFinishLock;
            synchronized (atomicBoolean) {
                SpeakerManager.this.mSpeakFinishLock.set(true);
                SpeakerManager.this.mSpeakFinishLock.notify();
            }
        }
    };

    SpeakerManager() {
    }

    public synchronized boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        if (this.isBind) {
            return true;
        }
        if (context == null) {
            throw new IllegalStateException("The context can not be null!");
        }
        if (listener == null) {
            throw new IllegalStateException("The listener can not be null!");
        }
        this.mContext = context.getApplicationContext();
        this.mListener = listener;
        Intent voiceServiceIntent = new Intent();
        voiceServiceIntent.setClassName(SPEAKER_SERVICE_PACKAGE_NAME, SPEAKER_SERVICE_CLASS_NAME);
        this.mContext.startService(voiceServiceIntent);
        Logger.d((String)TAG, (String)"try to connect to the speaker service");
        this.isBind = this.mContext.bindService(voiceServiceIntent, this.mServiceConnection, 1);
        return this.isBind;
    }

    public synchronized void unbindService() {
        Logger.d((String)TAG, (String)"unbindService");
        if (!this.isBind) {
            return;
        }
        if (this.mContext != null) {
            this.mContext.unbindService(this.mServiceConnection);
        }
        this.isBind = false;
        this.mISpeaker = null;
    }

    public ServiceBinder.BindStateListener getBindStateListener() {
        return this.mListener;
    }

    int getLanguage() throws RemoteException, VoiceException {
        if (this.mISpeaker == null) {
            throw new VoiceException("The tts service disconnected!");
        }
        int language = this.mISpeaker.getLanguage();
        if (language == 0) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void speak(String text, TtsListener ttsListener) throws VoiceException, RemoteException {
        if (this.mISpeaker == null) {
            throw new VoiceException("The speaker service is disconnected!");
        }
        if (ttsListener == null) {
            throw new IllegalArgumentException("The TtsListener cannot be null!");
        }
        if (this.isSpeaking) {
            throw new VoiceException("The speaker is speaking!");
        }
        this.isSpeaking = true;
        this.mTtsListener = ttsListener;
        this.mISpeaker.speak(text, this.mITtsListener);
        AtomicBoolean atomicBoolean = this.mSpeakFinishLock;
        synchronized (atomicBoolean) {
            this.mSpeakFinishLock.set(false);
        }
    }

    public void stopSpeak() throws RemoteException, VoiceException {
        if (this.mISpeaker == null) {
            throw new VoiceException("The speaker service disconnected!");
        }
        this.mISpeaker.stopSpeak();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSpeakFinish(long timeout) throws RemoteException {
        AtomicBoolean atomicBoolean = this.mSpeakFinishLock;
        synchronized (atomicBoolean) {
            long time = System.currentTimeMillis();
            while (!this.mSpeakFinishLock.get()) {
                try {
                    this.mSpeakFinishLock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            return System.currentTimeMillis() - time > timeout;
        }
    }

    public Version getVersion() {
        return new Version("STABLE", "0.5.6", 500006, 500000);
    }
}

