/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.segway.robot.sdk.base.bind.BindController;
import com.segway.robot.sdk.base.bind.ForegroundBindController;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.voice.SpeakerManager;
import com.segway.robot.sdk.voice.VoiceException;
import com.segway.robot.sdk.voice.tts.TtsListener;

public class Speaker {
    private static final String TAG = Speaker.class.getSimpleName();
    private static Speaker mSpeaker;
    private SpeakerManager mSpeakerManager;
    private boolean mBindControllerInit;
    private BindController mBindController = new ForegroundBindController();

    private Speaker() {
        this.mSpeakerManager = new SpeakerManager();
    }

    public static synchronized Speaker getInstance() {
        if (mSpeaker == null) {
            mSpeaker = new Speaker();
        }
        return mSpeaker;
    }

    public synchronized boolean bindService(@NonNull Context context, @NonNull ServiceBinder.BindStateListener listener) {
        if (!this.mBindControllerInit) {
            this.mBindControllerInit = true;
            this.mBindController.init(context, (ServiceBinder)this.mSpeakerManager);
        }
        if (this.mBindController.bindAcceptable()) {
            return this.mSpeakerManager.bindService(context, listener);
        }
        return false;
    }

    public synchronized void unbindService() {
        this.mSpeakerManager.unbindService();
    }

    public int getLanguage() throws RemoteException, VoiceException {
        return this.mSpeakerManager.getLanguage();
    }

    public synchronized void speak(@NonNull String text, @NonNull TtsListener ttsListener) throws VoiceException, RemoteException {
        this.mSpeakerManager.speak(text, ttsListener);
    }

    public void stopSpeak() throws RemoteException, VoiceException {
        this.mSpeakerManager.stopSpeak();
    }

    public boolean waitForSpeakFinish(long timeout) throws RemoteException {
        return this.mSpeakerManager.waitForSpeakFinish(timeout);
    }
}

