/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.voice.IVoiceService;
import com.segway.robot.sdk.voice.ServiceStateListener;
import com.segway.robot.sdk.voice.VoiceControlPermissionListener;
import com.segway.robot.sdk.voice.VoiceException;
import com.segway.robot.sdk.voice.VoicePermissionListener;
import com.segway.robot.sdk.voice.audiodata.IRawDataListener;
import com.segway.robot.sdk.voice.audiodata.RawDataListener;
import com.segway.robot.sdk.voice.grammar.GrammarConstraint;
import com.segway.robot.sdk.voice.grammar.IRebuildGrammarListener;
import com.segway.robot.sdk.voice.grammar.RebuildGrammarListener;
import com.segway.robot.sdk.voice.recognition.IRecognitionListener;
import com.segway.robot.sdk.voice.recognition.IWakeupListener;
import com.segway.robot.sdk.voice.recognition.RecognitionListener;
import com.segway.robot.sdk.voice.recognition.RecognitionResult;
import com.segway.robot.sdk.voice.recognition.WakeupListener;
import com.segway.robot.sdk.voice.recognition.WakeupResult;
import com.segway.robot.sdk.voice.tts.ITtsListener;
import com.segway.robot.sdk.voice.tts.TtsListener;

public class VoiceManager {
    private static final String TAG = VoiceManager.class.getSimpleName();
    private static final String SERVICE_PACKAGE_NAME = "com.segway.robot.coreservice.voiceservice";
    private static final String SERVICE_CLASS_NAME = "com.segway.robot.coreservice.voiceservice.VoiceAssistantService";
    private static final String SERVICE_ACTION = "com.segway.robot.coreservice.voiceservice.VOICE_SERVICE";
    private Context mContext;
    private IVoiceService mVoiceService;
    private ServiceStateListener mServiceStateListener;
    private static VoiceManager mVoiceManager;
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Logger.d((String)TAG, (String)"service connected");
            VoiceManager.this.mVoiceService = IVoiceService.Stub.asInterface(service);
            if (VoiceManager.this.mVoiceService != null) {
                VoiceManager.this.mServiceStateListener.onServiceConnected();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Logger.d((String)TAG, (String)"service disconnected");
            VoiceManager.this.mServiceStateListener.onServiceDisconnected();
            VoiceManager.this.mVoiceService = null;
        }
    };

    private VoiceManager() {
    }

    public static synchronized VoiceManager getInstance() {
        if (mVoiceManager == null) {
            mVoiceManager = new VoiceManager();
        }
        return mVoiceManager;
    }

    public boolean bind(Context context, ServiceStateListener callback) {
        if (context == null) {
            throw new IllegalStateException("The context cannot be null!");
        }
        if (callback == null) {
            throw new IllegalStateException("The ServiceStateListener cannot be null!");
        }
        this.mContext = context.getApplicationContext();
        this.mServiceStateListener = callback;
        Intent voiceServiceIntent = new Intent();
        voiceServiceIntent.setClassName(SERVICE_PACKAGE_NAME, SERVICE_CLASS_NAME);
        this.mContext.startService(voiceServiceIntent);
        Logger.d((String)TAG, (String)"try to connect to the voice service");
        return this.mContext.bindService(voiceServiceIntent, this.mServiceConnection, 1);
    }

    public void unbind() {
        Logger.d((String)TAG, (String)"unbindService");
        if (this.mContext != null) {
            this.mContext.unbindService(this.mServiceConnection);
            Intent voiceServiceIntent = new Intent();
            voiceServiceIntent.setClassName(SERVICE_PACKAGE_NAME, SERVICE_CLASS_NAME);
        }
    }

    public void acquireVoiceControlPermission(final VoicePermissionListener voicePermissionListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (voicePermissionListener == null) {
            throw new IllegalStateException("The VoicePermissionListener cannot be null!");
        }
        this.mVoiceService.acquireVoiceControlPermission(new VoiceControlPermissionListener.Stub(){

            @Override
            public void onPermit() throws RemoteException {
                voicePermissionListener.onPermit();
            }

            @Override
            public void onDeprive() throws RemoteException {
                voicePermissionListener.onDeprive();
            }
        });
    }

    public void releaseVoiceControlPermission() throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        this.mVoiceService.releaseVoiceControlPermission();
    }

    public boolean isCloudSupported() throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        return this.mVoiceService.isCloudSupported();
    }

    public void setRawDataListener(final RawDataListener rawDataListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (rawDataListener == null) {
            throw new IllegalStateException("The RawDataListener cannot be null!");
        }
        this.mVoiceService.setRawDataListener(new IRawDataListener.Stub(){

            @Override
            public void onRawData(byte[] data, int dataLength) throws RemoteException {
                rawDataListener.onRawData(data, dataLength);
            }
        });
    }

    public void startWakeup(final WakeupListener wakeupListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (wakeupListener == null) {
            throw new IllegalStateException("The WakeupListener cannot be null!");
        }
        this.mVoiceService.startWakeup(new IWakeupListener.Stub(){

            @Override
            public void onStandby() throws RemoteException {
                wakeupListener.onStandby();
            }

            @Override
            public void onWakeupResult(WakeupResult wakeupResult) throws RemoteException {
                wakeupListener.onWakeupResult(wakeupResult);
            }

            @Override
            public void onWakeupError(String error) throws RemoteException {
                wakeupListener.onWakeupError(error);
            }
        });
    }

    public void startRecognition(final RecognitionListener recognitionListener, boolean isLocal) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (recognitionListener == null) {
            throw new IllegalStateException("The RecognitionListener cannot be null!");
        }
        this.mVoiceService.startRecognition(new IRecognitionListener.Stub(){

            @Override
            public void onRecognitionStart() throws RemoteException {
                recognitionListener.onRecognitionStart();
            }

            @Override
            public boolean onRecognitionResult(RecognitionResult recognitionResult) throws RemoteException {
                return recognitionListener.onRecognitionResult(recognitionResult);
            }

            @Override
            public boolean onRecognitionError(String error) throws RemoteException {
                return recognitionListener.onRecognitionError(error);
            }
        }, isLocal);
    }

    public void stopRecognition() throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        try {
            this.mVoiceService.stopRecognition();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void speechToText(final RecognitionListener recognitionListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (recognitionListener == null) {
            throw new IllegalStateException("The RecognitionListener cannot be null!");
        }
        this.mVoiceService.speechToText(new IRecognitionListener.Stub(){

            @Override
            public void onRecognitionStart() throws RemoteException {
                recognitionListener.onRecognitionStart();
            }

            @Override
            public boolean onRecognitionResult(RecognitionResult recognitionResult) throws RemoteException {
                return recognitionListener.onRecognitionResult(recognitionResult);
            }

            @Override
            public boolean onRecognitionError(String error) throws RemoteException {
                return recognitionListener.onRecognitionError(error);
            }
        });
    }

    public void startSimpleVoiceControlMode(final WakeupListener wakeupListener, final RecognitionListener recognitionListener) throws RemoteException, VoiceException {
        Logger.d((String)TAG, (String)"start simple voice control mode");
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (wakeupListener == null) {
            throw new IllegalStateException("The WakeupListener cannot be null!");
        }
        if (recognitionListener == null) {
            throw new IllegalStateException("The RecognitionListener cannot be null!");
        }
        this.mVoiceService.startSimpleVoiceControlMode(new IWakeupListener.Stub(){

            @Override
            public void onStandby() throws RemoteException {
                wakeupListener.onStandby();
            }

            @Override
            public void onWakeupResult(WakeupResult wakeupResult) throws RemoteException {
                wakeupListener.onWakeupResult(wakeupResult);
            }

            @Override
            public void onWakeupError(String error) throws RemoteException {
                wakeupListener.onWakeupError(error);
            }
        }, new IRecognitionListener.Stub(){

            @Override
            public void onRecognitionStart() throws RemoteException {
                recognitionListener.onRecognitionStart();
            }

            @Override
            public boolean onRecognitionResult(RecognitionResult recognitionResult) throws RemoteException {
                return recognitionListener.onRecognitionResult(recognitionResult);
            }

            @Override
            public boolean onRecognitionError(String error) throws RemoteException {
                return recognitionListener.onRecognitionError(error);
            }
        });
    }

    public void textToSpeech(String text, final TtsListener ttsListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (ttsListener == null) {
            throw new IllegalStateException("The TtsListener cannot be null!");
        }
        this.mVoiceService.textToSpeech(text, new ITtsListener.Stub(){

            @Override
            public void onSpeechStarted(String word) throws RemoteException {
                ttsListener.onSpeechStarted(word);
            }

            @Override
            public void onSpeechFinished(String word) throws RemoteException {
                ttsListener.onSpeechFinished(word);
            }

            @Override
            public void onSpeechError(String word, String reason) throws RemoteException {
                ttsListener.onSpeechError(word, reason);
            }
        });
    }

    public void stopSpeech() throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        this.mVoiceService.stopSpeech();
    }

    public void getBeamFormerData() throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        this.mVoiceService.getBeamFormerData();
    }

    public void stopBeamFormer() throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        this.mVoiceService.stopBeamFormer();
    }

    public boolean addGrammarConstraint(GrammarConstraint grammarConstraint) throws RemoteException, VoiceException {
        Logger.d((String)TAG, (String)("add a grammar constraint, it is " + grammarConstraint.getName()));
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (grammarConstraint == null || grammarConstraint.getSlotList().isEmpty()) {
            throw new IllegalStateException("grammar constraint is illegal");
        }
        return this.mVoiceService.addGrammarConstraint(grammarConstraint);
    }

    public boolean rebuildGrammar(final RebuildGrammarListener rebuildGrammarListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (rebuildGrammarListener == null) {
            throw new IllegalStateException("The RebuildGrammarListener cannot be null!");
        }
        return this.mVoiceService.rebuildGrammar(new IRebuildGrammarListener.Stub(){

            @Override
            public void onComplete() throws RemoteException {
                rebuildGrammarListener.onComplete();
            }

            @Override
            public void onError(String error) throws RemoteException {
                rebuildGrammarListener.onError(error);
            }
        });
    }

    public boolean resetAppGrammar(final RebuildGrammarListener rebuildGrammarListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (rebuildGrammarListener == null) {
            throw new IllegalStateException("The RebuildGrammarListener cannot be null!");
        }
        return this.mVoiceService.resetAppGrammar(new IRebuildGrammarListener.Stub(){

            @Override
            public void onComplete() throws RemoteException {
                rebuildGrammarListener.onComplete();
            }

            @Override
            public void onError(String error) throws RemoteException {
                rebuildGrammarListener.onError(error);
            }
        });
    }

    public boolean resetSystemGrammar(final RebuildGrammarListener rebuildGrammarListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (rebuildGrammarListener == null) {
            throw new IllegalStateException("The RebuildGrammarListener cannot be null!");
        }
        return this.mVoiceService.resetSystemGrammar(new IRebuildGrammarListener.Stub(){

            @Override
            public void onComplete() throws RemoteException {
                rebuildGrammarListener.onComplete();
            }

            @Override
            public void onError(String error) throws RemoteException {
                rebuildGrammarListener.onError(error);
            }
        });
    }

    public boolean addSystemGrammarConstraint(GrammarConstraint grammarConstraint) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (grammarConstraint == null || grammarConstraint.getSlotList().isEmpty()) {
            throw new IllegalStateException("the grammar constraint is illegal");
        }
        return this.mVoiceService.addSystemGrammarConstraint(grammarConstraint);
    }

    public void setSystemRecognitionListener(final RecognitionListener systemRecognitionListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (systemRecognitionListener == null) {
            throw new IllegalStateException("The RecognitionListener cannot be null!");
        }
        this.mVoiceService.setSystemRecognitionListener(new IRecognitionListener.Stub(){

            @Override
            public void onRecognitionStart() throws RemoteException {
                systemRecognitionListener.onRecognitionStart();
            }

            @Override
            public boolean onRecognitionResult(RecognitionResult recognitionResult) throws RemoteException {
                return systemRecognitionListener.onRecognitionResult(recognitionResult);
            }

            @Override
            public boolean onRecognitionError(String error) throws RemoteException {
                return systemRecognitionListener.onRecognitionError(error);
            }
        });
    }

    public void setApplicationRecognitionListener(final RecognitionListener applicationRecognitionListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (applicationRecognitionListener == null) {
            throw new IllegalStateException("The RecognitionListener cannot be null!");
        }
        this.mVoiceService.setApplicationRecognitionListener(new IRecognitionListener.Stub(){

            @Override
            public void onRecognitionStart() throws RemoteException {
                applicationRecognitionListener.onRecognitionStart();
            }

            @Override
            public boolean onRecognitionResult(RecognitionResult recognitionResult) throws RemoteException {
                return applicationRecognitionListener.onRecognitionResult(recognitionResult);
            }

            @Override
            public boolean onRecognitionError(String error) throws RemoteException {
                return applicationRecognitionListener.onRecognitionError(error);
            }
        });
    }

    public void setApplicationWakeupListener(final WakeupListener applicationWakeupListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (applicationWakeupListener == null) {
            throw new IllegalStateException("The WakeupListener cannot be null!");
        }
        this.mVoiceService.setApplicationWakeupListener(new IWakeupListener.Stub(){

            @Override
            public void onStandby() throws RemoteException {
                applicationWakeupListener.onStandby();
            }

            @Override
            public void onWakeupResult(WakeupResult wakeupResult) throws RemoteException {
                applicationWakeupListener.onWakeupResult(wakeupResult);
            }

            @Override
            public void onWakeupError(String error) throws RemoteException {
                applicationWakeupListener.onWakeupError(error);
            }
        });
    }

    public void setSystemWakeupListener(final WakeupListener systemWakeupListener) throws RemoteException, VoiceException {
        if (this.mVoiceService == null) {
            throw new VoiceException("The voice service disconnected!");
        }
        if (systemWakeupListener == null) {
            throw new IllegalStateException("The WakeupListener cannot be null!");
        }
        this.mVoiceService.setSystemWakeupListener(new IWakeupListener.Stub(){

            @Override
            public void onStandby() throws RemoteException {
                systemWakeupListener.onStandby();
            }

            @Override
            public void onWakeupResult(WakeupResult wakeupResult) throws RemoteException {
                systemWakeupListener.onWakeupResult(wakeupResult);
            }

            @Override
            public void onWakeupError(String error) throws RemoteException {
                systemWakeupListener.onWakeupError(error);
            }
        });
    }

    public void enableBeamForming() throws RemoteException {
        this.mVoiceService.enableBeamForming();
    }

    public void disableBeamForming() throws RemoteException {
        this.mVoiceService.disableBeamForming();
    }
}

