package com.segway.robot.sdk.voice.tts;

/**
 * A listener which provides callbacks for certain text-to-speech (TTS) generation events.
 */
public interface TtsListener {

    /**
     * This method is called when TTS begins.
     */
    void onSpeechStarted(String word);

    /**
     * This method is called when TTS finishes.
     */
    void onSpeechFinished(String word);

    /**
     * TTS error.
     * @param reason
     */
    void onSpeechError(String word, String reason);
}
