/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.base.version.VersionMismatchException;
import com.segway.robot.sdk.voice.CheckUtil;
import com.segway.robot.sdk.voice.IRecognizer;
import com.segway.robot.sdk.voice.VoiceException;
import com.segway.robot.sdk.voice.audiodata.IRawDataListener;
import com.segway.robot.sdk.voice.audiodata.RawDataListener;
import com.segway.robot.sdk.voice.grammar.GrammarCheckUtil;
import com.segway.robot.sdk.voice.grammar.GrammarConstraint;
import com.segway.robot.sdk.voice.grammar.Slot;
import com.segway.robot.sdk.voice.recognition.IRecognitionListener;
import com.segway.robot.sdk.voice.recognition.IWakeupListener;
import com.segway.robot.sdk.voice.recognition.RecognitionListener;
import com.segway.robot.sdk.voice.recognition.RecognitionResult;
import com.segway.robot.sdk.voice.recognition.WakeupListener;
import com.segway.robot.sdk.voice.recognition.WakeupResult;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class RecognizerManager
implements ServiceBinder {
    private static final String TAG = RecognizerManager.class.getSimpleName();
    private static final String RECOGNIZER_SERVICE_PACKAGE_NAME = "com.segway.robot.coreservice.voiceservice";
    private static final String RECOGNIZER_SERVICE_CLASS_NAME = "com.segway.robot.coreservice.voiceservice.RecognitionService";
    final int BIT_RATE = 16;
    final int SAMPLE_RATE = 16000;
    IRecognizer mIRecognizer;
    private Context mContext;
    private ServiceBinder.BindStateListener mListener;
    private boolean isBind = false;
    private WakeupListener mWakeupListener;
    private RecognitionListener mRecognitionListener;
    private RawDataListener mRawDataListener;
    private final Object mLockWakeupListener;
    private final Object mLockRecognitionListener;
    private IWakeupListener.Stub mIWakeupListener = new IWakeupListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStandby() {
            Object object = RecognizerManager.this.mLockWakeupListener;
            synchronized (object) {
                if (RecognizerManager.this.mWakeupListener != null) {
                    RecognizerManager.this.mWakeupListener.onStandby();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWakeupResult(WakeupResult wakeupResult) {
            Object object = RecognizerManager.this.mLockWakeupListener;
            synchronized (object) {
                if (RecognizerManager.this.mWakeupListener != null) {
                    RecognizerManager.this.mWakeupListener.onWakeupResult(wakeupResult);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWakeupError(String error) {
            Object object = RecognizerManager.this.mLockWakeupListener;
            synchronized (object) {
                if (RecognizerManager.this.mWakeupListener != null) {
                    RecognizerManager.this.mWakeupListener.onWakeupError(error);
                }
            }
        }
    };
    private IRecognitionListener.Stub mIRecognitionListener = new IRecognitionListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRecognitionStart() {
            Object object = RecognizerManager.this.mLockRecognitionListener;
            synchronized (object) {
                if (RecognizerManager.this.mRecognitionListener != null) {
                    RecognizerManager.this.mRecognitionListener.onRecognitionStart();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onRecognitionResult(RecognitionResult recognitionResult) {
            boolean doRecognition;
            Object object = RecognizerManager.this.mLockRecognitionListener;
            synchronized (object) {
                doRecognition = RecognizerManager.this.mRecognitionListener != null && RecognizerManager.this.mRecognitionListener.onRecognitionResult(recognitionResult);
            }
            return doRecognition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onRecognitionError(String error) {
            boolean doRecognition;
            Object object = RecognizerManager.this.mLockRecognitionListener;
            synchronized (object) {
                doRecognition = RecognizerManager.this.mRecognitionListener != null && RecognizerManager.this.mRecognitionListener.onRecognitionError(error);
            }
            return doRecognition;
        }
    };
    private IRawDataListener.Stub mIRawDataListener = new IRawDataListener.Stub(){

        @Override
        public void onRawData(byte[] data, int dataLength) {
            RecognizerManager.this.mRawDataListener.onRawData(data, dataLength);
        }
    };
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Logger.i((String)TAG, (String)"service connected");
            RecognizerManager.this.mIRecognizer = IRecognizer.Stub.asInterface(service);
            RecognizerManager.this.afterOnServiceConnected();
        }

        public void onServiceDisconnected(ComponentName name) {
            Logger.i((String)TAG, (String)"service disconnected");
            RecognizerManager.this.isBind = false;
            RecognizerManager.this.mListener.onUnbind("The recognition service disconnected!");
            RecognizerManager.this.mIRecognizer = null;
        }
    };

    RecognizerManager() {
        this.mLockWakeupListener = new Object();
        this.mLockRecognitionListener = new Object();
    }

    protected void afterOnServiceConnected() {
        try {
            Version serviceVersion = this.mIRecognizer.getVersion();
            this.getVersion().check("VersionInfo", serviceVersion);
        }
        catch (RemoteException e) {
            String error = "Cannot get Recognition Service version, err = " + e.getMessage();
            this.mListener.onUnbind(error);
            this.mIRecognizer = null;
            this.unbindService();
            Logger.e((String)TAG, (String)error, (Throwable)e);
            return;
        }
        catch (VersionMismatchException e) {
            String error = "Version mismatch: " + e.getMessage();
            this.mListener.onUnbind(error);
            this.mIRecognizer = null;
            this.unbindService();
            Logger.e((String)TAG, (String)"Version mismatch", (Throwable)e);
            return;
        }
        if (this.mIRecognizer != null) {
            try {
                this.mIRecognizer.registerWatcher((IBinder)new Binder(), this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Logger.e((String)TAG, (String)"onServiceConnected: ", (Throwable)e);
                this.mListener.onUnbind(e.getMessage());
                this.unbindService();
                return;
            }
            this.mListener.onBind();
        }
    }

    public synchronized boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        Logger.i((String)TAG, (String)"RecognizerManager bindService");
        if (this.isBind) {
            return true;
        }
        if (context == null) {
            throw new IllegalArgumentException("The context cannot be null!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("The BindStateListener cannot be null!");
        }
        this.mContext = context.getApplicationContext();
        this.mListener = listener;
        Intent voiceServiceIntent = new Intent();
        voiceServiceIntent.setClassName(RECOGNIZER_SERVICE_PACKAGE_NAME, RECOGNIZER_SERVICE_CLASS_NAME);
        this.mContext.startService(voiceServiceIntent);
        Logger.i((String)TAG, (String)"try to connect to the recognition service");
        this.isBind = this.mContext.bindService(voiceServiceIntent, this.mServiceConnection, 1);
        return this.isBind;
    }

    public synchronized void unbindService() {
        Logger.i((String)TAG, (String)"unbindService");
        Logger.i((String)TAG, (String)("isBind: " + this.isBind));
        if (!this.isBind) {
            return;
        }
        if (this.mContext != null) {
            if (this.mIRecognizer != null) {
                try {
                    this.mIRecognizer.unregisterWatcher(this.mContext.getPackageName());
                }
                catch (RemoteException e) {
                    Logger.e((String)TAG, (String)"RemoteException: ", (Throwable)e);
                }
            }
            this.mContext.unbindService(this.mServiceConnection);
        }
        this.isBind = false;
        this.mIRecognizer = null;
    }

    public boolean isBind() {
        return this.isBind;
    }

    public ServiceBinder.BindStateListener getBindStateListener() {
        return this.mListener;
    }

    int getLanguage() throws VoiceException {
        this.checkConnectionStatus();
        int language = 0;
        try {
            language = this.mIRecognizer.getLanguage();
        }
        catch (RemoteException e) {
            throw new VoiceException("getLanguage", e);
        }
        if (language == 0) {
            return 0;
        }
        return 1;
    }

    void beamForming(boolean enable) throws VoiceException {
        this.checkConnectionStatus();
        try {
            this.mIRecognizer.beamForming(enable);
        }
        catch (RemoteException e) {
            throw new VoiceException("beamForming", e);
        }
    }

    GrammarConstraint createGrammarConstraint(String json) throws VoiceException {
        GrammarConstraint grammarFromJson;
        try {
            JSONObject grammarConstraintObject = new JSONObject(json);
            ArrayList<Slot> slotList = new ArrayList<Slot>();
            String name = grammarConstraintObject.getString("name");
            JSONArray slotListFromJson = grammarConstraintObject.getJSONArray("slotList");
            int length = slotListFromJson.length();
            for (int i = 0; i < length; ++i) {
                JSONObject slotObject = slotListFromJson.getJSONObject(i);
                Slot slot = new Slot(slotObject.getString("name"));
                slot.setOptional(slotObject.getBoolean("isOptional"));
                JSONArray wordListFromJson = slotObject.getJSONArray("word");
                int wordLength = wordListFromJson.length();
                String[] words = new String[wordLength];
                for (int j = 0; j < wordLength; ++j) {
                    words[j] = wordListFromJson.getString(j);
                }
                slot.addWordsArray(words);
                slotList.add(slot);
            }
            grammarFromJson = new GrammarConstraint(name, slotList);
        }
        catch (JSONException e) {
            throw new VoiceException("Json illegal, exception: ", e);
        }
        if (GrammarCheckUtil.containSystemGrammar(grammarFromJson)) {
            throw new VoiceException("This GrammarConstraint(" + grammarFromJson.getName() + ") contains one or more system grammars.");
        }
        return grammarFromJson;
    }

    void addGrammarConstraint(GrammarConstraint grammarConstraint) throws VoiceException {
        this.checkConnectionStatus();
        if (grammarConstraint.getName() == null || grammarConstraint.getName().equals("")) {
            throw new IllegalArgumentException("Your grammar constraint has no name!");
        }
        int language = this.getLanguage();
        Logger.i((String)TAG, (String)("RecognitionLanguage: " + language));
        List<Slot> slotList = grammarConstraint.getSlotList();
        int size = slotList.size();
        if (size == 0) {
            throw new IllegalArgumentException("Your grammar constraint has no slot!");
        }
        boolean b = true;
        for (Slot slot : slotList) {
            b = language == 0 ? CheckUtil.isEnSlot(slot) : CheckUtil.isCnSlot(slot);
            if (b) continue;
            Logger.e((String)TAG, (String)("\"" + slot.getName() + "\" is an illegal slot"));
            throw new VoiceException("\"" + slot.getName() + "\" is an illegal slot");
        }
        if (GrammarCheckUtil.containSystemGrammar(grammarConstraint)) {
            throw new VoiceException("This GrammarConstraint(" + grammarConstraint.getName() + ") contains one or more system grammars.");
        }
        try {
            this.mIRecognizer.addGrammarConstraint(grammarConstraint);
        }
        catch (RemoteException e) {
            throw new VoiceException("addGrammarConstraint", e);
        }
    }

    void removeGrammarConstraint(GrammarConstraint grammarConstraint) throws VoiceException {
        this.checkConnectionStatus();
        try {
            this.mIRecognizer.removeGrammarConstraint(grammarConstraint);
        }
        catch (RemoteException e) {
            throw new VoiceException("removeGrammarConstraint", e);
        }
    }

    synchronized void startRecognition(WakeupListener wakeUpListener, RecognitionListener recognitionListener) throws VoiceException {
        this.checkConnectionStatus();
        if (wakeUpListener == null) {
            throw new IllegalArgumentException("The WakeupListener cannot be null!");
        }
        if (recognitionListener == null) {
            throw new IllegalArgumentException("The RecognitionListener cannot be null!");
        }
        this.mWakeupListener = wakeUpListener;
        this.mRecognitionListener = recognitionListener;
        try {
            this.mIRecognizer.startRecognition(this.mIWakeupListener, this.mIRecognitionListener);
        }
        catch (RemoteException e) {
            throw new VoiceException("startRecognition", e);
        }
    }

    void stopRecognition() throws VoiceException {
        this.checkConnectionStatus();
        this.mWakeupListener = null;
        this.mRecognitionListener = null;
        try {
            this.mIRecognizer.stopRecognition();
        }
        catch (RemoteException e) {
            throw new VoiceException("stopRecognition", e);
        }
    }

    void startBeamFormingListen(RawDataListener listener) throws VoiceException {
        this.checkConnectionStatus();
        this.mRawDataListener = listener;
        try {
            this.mIRecognizer.startBeamFormingListen(this.mIRawDataListener);
        }
        catch (RemoteException e) {
            throw new VoiceException("startBeamFormingListen", e);
        }
    }

    void stopBeamFormingListen() throws VoiceException {
        this.checkConnectionStatus();
        try {
            this.mIRecognizer.stopBeamFormingListen();
        }
        catch (RemoteException e) {
            throw new VoiceException("stopBeamFormingListen", e);
        }
    }

    void setSoundEnabled(boolean enabled) throws VoiceException {
        this.checkConnectionStatus();
        try {
            this.mIRecognizer.setSoundEnabled(enabled);
        }
        catch (RemoteException e) {
            throw new VoiceException("setSoundEnabled", e);
        }
    }

    void disconnectService() throws VoiceException {
        this.checkConnectionStatus();
        try {
            this.mIRecognizer.disconnectService();
        }
        catch (RemoteException e) {
            throw new VoiceException("disconnectService", e);
        }
    }

    public Version getVersion() {
        return new Version("STABLE", "0.5.237", 5000237, 500000);
    }

    synchronized void startWakeupMode(WakeupListener wakeUpListener) throws VoiceException {
        this.checkConnectionStatus();
        if (wakeUpListener == null) {
            throw new IllegalArgumentException("The WakeupListener cannot be null!");
        }
        this.mWakeupListener = wakeUpListener;
        try {
            this.mIRecognizer.startWakeupMode(this.mIWakeupListener);
        }
        catch (RemoteException e) {
            throw new VoiceException("startWakeupMode", e);
        }
    }

    synchronized void startRecognitionMode(RecognitionListener recognitionListener) throws VoiceException {
        this.checkConnectionStatus();
        if (recognitionListener == null) {
            throw new IllegalArgumentException("The RecognitionListener cannot be null!");
        }
        this.mRecognitionListener = recognitionListener;
        try {
            this.mIRecognizer.startRecognitionMode(this.mIRecognitionListener);
        }
        catch (RemoteException e) {
            throw new VoiceException("startRecognitionMode", e);
        }
    }

    synchronized void startRecognitionAndWakeup(RecognitionListener recognitionListener, WakeupListener wakeUpListener) throws VoiceException {
        this.checkConnectionStatus();
        if (wakeUpListener == null) {
            throw new IllegalArgumentException("The WakeupListener cannot be null!");
        }
        if (recognitionListener == null) {
            throw new IllegalArgumentException("The RecognitionListener cannot be null!");
        }
        this.mWakeupListener = wakeUpListener;
        this.mRecognitionListener = recognitionListener;
        try {
            this.mIRecognizer.startNewRecognition(this.mIWakeupListener, this.mIRecognitionListener);
        }
        catch (RemoteException e) {
            throw new VoiceException("startRecognitionAndWakeup", e);
        }
    }

    void checkConnectionStatus() throws VoiceException {
        if (this.mIRecognizer == null) {
            throw new VoiceException("The voice service disconnected!");
        }
    }

    protected void setIRecognizer(IRecognizer recognizer) {
        this.mIRecognizer = recognizer;
    }
}

