package com.segway.robot.sdk.voice.recognition;

/**
 * A listener that provides the results,
 * or the error description if an error occurs.
 */
public interface RecognitionListener {

    /**
     * This method is called when the recognition begins.
     */
    void onRecognitionStart();

    /**
     * This method is called when the recognition finishes and the result is available.
     * @param recognitionResult the {@link RecognitionResult} of the recognition.
     * @return true Execute the recognition operation or the wake-up operation.
     */
    boolean onRecognitionResult(RecognitionResult recognitionResult);

    /**
     * This method is called when the recognition fails.
     *
     * @param error the reason of the failure.
     * @return true Execute the recognition operation or the wake-up operation.
     */
    boolean onRecognitionError(String error);
}
