package com.segway.robot.sdk.voice.recognition;

import android.os.Parcel;
import android.os.Parcelable;

public class WakeupResult implements Parcelable {
    private String mResult;
    private int mAngle;

    /**
     * The parcel constructor of the WakeupResult class.
     *
     * @param in the parcel where to read the wake-up's result and angle.
     */
    protected WakeupResult(Parcel in) {
        mResult = in.readString();
        mAngle = in.readInt();
    }

    /**
     * the constructor of the WakeupResult class.
     */
    public WakeupResult() {
        super();
    }

    /**
     * the constructor of the WakeupResult class.
     *
     * @param result the result of wake-up.
     * @param angle  the angle of wake-up orientation.
     */
    public WakeupResult(String result, int angle) {
        this.mResult = result;
        this.mAngle = angle;
    }

    public static final Creator<WakeupResult> CREATOR = new Creator<WakeupResult>() {

        /**
         * @return a new WakeupResult from the data in the specified parcel.
         */
        @Override
        public WakeupResult createFromParcel(Parcel in) {
            return new WakeupResult(in);
        }

        /**
         * @return an array of WakeupResult of the specified size.
         */
        @Override
        public WakeupResult[] newArray(int size) {
            return new WakeupResult[size];
        }
    };

    /**
     * Set the result of wake-up.
     *
     * @param result the result of wake-up.
     */
    public void setResult(String result) {
        this.mResult = result;
    }

    /**
     * Set the angle of wake-up.
     *
     * @param angle the angle of wake-up.
     */
    public void setAngle(int angle) {
        this.mAngle = angle;
    }

    /**
     * Get the result of wake-up.
     *
     * @return the result of wake-up.
     */
    public String getResult() {
        return this.mResult;
    }

    /**
     * Get the angle of wake-up.
     *
     * @return the angle of wake-up.
     */
    public int getAngle() {
        return this.mAngle;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mResult);
        dest.writeInt(mAngle);
    }

    /**
     * Read the result and the angle of the wake-up from the data in the specified parcel.
     *
     * @param in the parcel where to read the wake-up's result and angle.
     */
    public void readFromParcel(Parcel in) {
        mResult = in.readString();
        mAngle = in.readInt();
    }
}
