/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

class GrammarJsonValidator {
    GrammarJsonValidator() {
    }

    boolean validate(String input) {
        input = input.trim();
        return this.valid(input);
    }

    private boolean valid(String input) {
        if ("".equals(input)) {
            return true;
        }
        boolean ret = true;
        StringCharacterIterator it = new StringCharacterIterator(input);
        it.first();
        if (!this.value(it)) {
            ret = false;
        } else {
            this.skipWhiteSpace(it);
            if (it.current() != '\uffff') {
                ret = false;
            }
        }
        return ret;
    }

    private boolean value(CharacterIterator it) {
        return this.literal("true", it) || this.literal("false", it) || this.string(it) || this.object(it) || this.array(it);
    }

    private boolean literal(String text, CharacterIterator it) {
        StringCharacterIterator ci = new StringCharacterIterator(text);
        char t = ci.first();
        if (it.current() != t) {
            return false;
        }
        boolean ret = true;
        t = ci.next();
        while (t != '\uffff') {
            if (t != this.nextCharacter(it)) {
                ret = false;
                break;
            }
            t = ci.next();
        }
        this.nextCharacter(it);
        if (!ret) {
            ret = false;
        }
        return ret;
    }

    private boolean array(CharacterIterator it) {
        return this.aggregate('[', ']', false, it);
    }

    private boolean object(CharacterIterator it) {
        return this.aggregate('{', '}', true, it);
    }

    private boolean aggregate(char entryCharacter, char exitCharacter, boolean prefix, CharacterIterator it) {
        if (it.current() != entryCharacter) {
            return false;
        }
        this.nextCharacter(it);
        this.skipWhiteSpace(it);
        if (it.current() == exitCharacter) {
            this.nextCharacter(it);
            return true;
        }
        while (true) {
            if (prefix) {
                if (!this.string(it)) {
                    return false;
                }
                this.skipWhiteSpace(it);
                if (it.current() != ':') {
                    return false;
                }
                this.nextCharacter(it);
                this.skipWhiteSpace(it);
            }
            if (this.value(it)) {
                this.skipWhiteSpace(it);
                if (it.current() != ',') {
                    if (it.current() == exitCharacter) break;
                    return false;
                }
            } else {
                return false;
            }
            this.nextCharacter(it);
            this.skipWhiteSpace(it);
        }
        this.nextCharacter(it);
        return true;
    }

    private boolean string(CharacterIterator it) {
        if (it.current() != '\"') {
            return false;
        }
        boolean escaped = false;
        this.nextCharacter(it);
        while (it.current() != '\uffff') {
            if (!escaped && it.current() == '\\') {
                escaped = true;
            } else if (escaped) {
                if (!this.escape(it)) {
                    return false;
                }
                escaped = false;
            } else if (it.current() == '\"') {
                this.nextCharacter(it);
                return true;
            }
            this.nextCharacter(it);
        }
        return false;
    }

    private boolean escape(CharacterIterator it) {
        if (" \\\"/bfnrtu".indexOf(it.current()) < 0) {
            return false;
        }
        return it.current() != 'u' || this.ishex(this.nextCharacter(it)) && this.ishex(this.nextCharacter(it)) && this.ishex(this.nextCharacter(it)) && this.ishex(this.nextCharacter(it));
    }

    private boolean ishex(char d) {
        return "0123456789abcdefABCDEF".indexOf(d) >= 0;
    }

    private char nextCharacter(CharacterIterator it) {
        return it.next();
    }

    private void skipWhiteSpace(CharacterIterator it) {
        while (Character.isWhitespace(it.current())) {
            this.nextCharacter(it);
        }
    }
}

