package com.segway.robot.sdk.voice.grammar;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.voice.VoiceException;

import java.util.ArrayList;
import java.util.List;

import static java.util.Arrays.asList;

public class GrammarCheckUtil {

    private static final String TAG = "GrammarCheckUtil";

    public static List<String> getAllGrammar(GrammarConstraint grammarConstraint) {
        List<String> slotString;
        List<Slot> slotList = grammarConstraint.getSlotList();
        int slotSize = slotList.size();
        slotString = slotList.get(0).getWordList();
        if (slotSize == 1) {
            return slotString;
        }
        int current = 1;
        do {
            slotString = jointSlots(slotString, slotList.get(current));
            current++;
        } while (current < slotSize);
        return slotString;
    }

    private static List<String> jointSlots(List<String> foreContentList, Slot nextSlot) {
        List<String> grammar = new ArrayList<>();
        boolean nextSlotOpt = nextSlot.getOptional();
        int foreContentListSize = foreContentList.size();
        int nextSlotSize = nextSlot.getWordList().size();
        if (nextSlotOpt) {
            grammar.addAll(foreContentList);
        }
        List<String> nextSlotStringList = nextSlot.getWordList();
        for (int i = 0; i < foreContentListSize; i++) {
            for (int j = 0; j < nextSlotSize; j++) {
                grammar.add(foreContentList.get(i) + " " + nextSlotStringList.get(j));
            }
        }
        return grammar;
    }

    public static boolean containSystemGrammar(GrammarConstraint grammarConstraint) {
        List<String> testGrammarList = getAllGrammar(grammarConstraint);
        boolean ret = false;
        for(String grammar : testGrammarList) {
            if (SYSTEM_GRAMMAR.contains(grammar)) {
                Logger.e(TAG, "\"" + grammar + "\" is system grammar.");
                ret = true;
            }
        }
        return ret;
    }

    private static final List<String> SYSTEM_GRAMMAR = asList(
            "loomo loomo",
            "ok loomo",
            "hey loomo",
            "yo loomo",
            "hello loomo",
            "hi loomo"
    );
}
