/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.voice.InitEngineListener;
import com.segway.robot.sdk.voice.VoiceControlPermissionListener;
import com.segway.robot.sdk.voice.VoiceServiceStateListener;
import com.segway.robot.sdk.voice.audiodata.IRawDataListener;
import com.segway.robot.sdk.voice.grammar.GrammarConstraint;
import com.segway.robot.sdk.voice.grammar.IRebuildGrammarListener;
import com.segway.robot.sdk.voice.recognition.IRecognitionListener;
import com.segway.robot.sdk.voice.recognition.IWakeupListener;
import com.segway.robot.sdk.voice.tts.ITtsListener;

public interface IVoiceService
extends IInterface {
    public void registerApp() throws RemoteException;

    public void logoutApp() throws RemoteException;

    public void acquireVoiceControlPermission(VoiceControlPermissionListener var1) throws RemoteException;

    public void releaseVoiceControlPermission() throws RemoteException;

    public boolean isCloudSupported() throws RemoteException;

    public void registerVoiceServiceStateListener(VoiceServiceStateListener var1) throws RemoteException;

    public void initVoiceControlEngine(InitEngineListener var1) throws RemoteException;

    public void setRawDataListener(IRawDataListener var1) throws RemoteException;

    public void startWakeup(IWakeupListener var1) throws RemoteException;

    public void startRecognition(IRecognitionListener var1, boolean var2) throws RemoteException;

    public void speechToText(IRecognitionListener var1) throws RemoteException;

    public void startSimpleVoiceControlMode(IWakeupListener var1, IRecognitionListener var2) throws RemoteException;

    public void stopRecognition() throws RemoteException;

    public void textToSpeech(String var1, ITtsListener var2) throws RemoteException;

    public void stopSpeech() throws RemoteException;

    public void getBeamFormerData() throws RemoteException;

    public void stopBeamFormer() throws RemoteException;

    public boolean addGrammarConstraint(GrammarConstraint var1) throws RemoteException;

    public boolean rebuildGrammar(IRebuildGrammarListener var1) throws RemoteException;

    public boolean resetAppGrammar(IRebuildGrammarListener var1) throws RemoteException;

    public boolean resetSystemGrammar(IRebuildGrammarListener var1) throws RemoteException;

    public boolean addSystemGrammarConstraint(GrammarConstraint var1) throws RemoteException;

    public void setApplicationWakeupListener(IWakeupListener var1) throws RemoteException;

    public void setSystemWakeupListener(IWakeupListener var1) throws RemoteException;

    public void setSystemRecognitionListener(IRecognitionListener var1) throws RemoteException;

    public void setApplicationRecognitionListener(IRecognitionListener var1) throws RemoteException;

    public void enableBeamForming() throws RemoteException;

    public void disableBeamForming() throws RemoteException;

    public Version getVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVoiceService {
        private static final String DESCRIPTOR = "com.segway.robot.sdk.voice.IVoiceService";
        static final int TRANSACTION_registerApp = 1;
        static final int TRANSACTION_logoutApp = 2;
        static final int TRANSACTION_acquireVoiceControlPermission = 3;
        static final int TRANSACTION_releaseVoiceControlPermission = 4;
        static final int TRANSACTION_isCloudSupported = 5;
        static final int TRANSACTION_registerVoiceServiceStateListener = 6;
        static final int TRANSACTION_initVoiceControlEngine = 7;
        static final int TRANSACTION_setRawDataListener = 8;
        static final int TRANSACTION_startWakeup = 9;
        static final int TRANSACTION_startRecognition = 10;
        static final int TRANSACTION_speechToText = 11;
        static final int TRANSACTION_startSimpleVoiceControlMode = 12;
        static final int TRANSACTION_stopRecognition = 13;
        static final int TRANSACTION_textToSpeech = 14;
        static final int TRANSACTION_stopSpeech = 15;
        static final int TRANSACTION_getBeamFormerData = 16;
        static final int TRANSACTION_stopBeamFormer = 17;
        static final int TRANSACTION_addGrammarConstraint = 18;
        static final int TRANSACTION_rebuildGrammar = 19;
        static final int TRANSACTION_resetAppGrammar = 20;
        static final int TRANSACTION_resetSystemGrammar = 21;
        static final int TRANSACTION_addSystemGrammarConstraint = 22;
        static final int TRANSACTION_setApplicationWakeupListener = 23;
        static final int TRANSACTION_setSystemWakeupListener = 24;
        static final int TRANSACTION_setSystemRecognitionListener = 25;
        static final int TRANSACTION_setApplicationRecognitionListener = 26;
        static final int TRANSACTION_enableBeamForming = 27;
        static final int TRANSACTION_disableBeamForming = 28;
        static final int TRANSACTION_getVersion = 29;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IVoiceService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IVoiceService) {
                return (IVoiceService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    this.registerApp();
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    this.logoutApp();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    VoiceControlPermissionListener _arg0 = VoiceControlPermissionListener.Stub.asInterface(data.readStrongBinder());
                    this.acquireVoiceControlPermission(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    this.releaseVoiceControlPermission();
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isCloudSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    VoiceServiceStateListener _arg0 = VoiceServiceStateListener.Stub.asInterface(data.readStrongBinder());
                    this.registerVoiceServiceStateListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    InitEngineListener _arg0 = InitEngineListener.Stub.asInterface(data.readStrongBinder());
                    this.initVoiceControlEngine(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    IRawDataListener _arg0 = IRawDataListener.Stub.asInterface(data.readStrongBinder());
                    this.setRawDataListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    IWakeupListener _arg0 = IWakeupListener.Stub.asInterface(data.readStrongBinder());
                    this.startWakeup(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    IRecognitionListener _arg0 = IRecognitionListener.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = 0 != data.readInt();
                    this.startRecognition(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    IRecognitionListener _arg0 = IRecognitionListener.Stub.asInterface(data.readStrongBinder());
                    this.speechToText(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    IWakeupListener _arg0 = IWakeupListener.Stub.asInterface(data.readStrongBinder());
                    IRecognitionListener _arg1 = IRecognitionListener.Stub.asInterface(data.readStrongBinder());
                    this.startSimpleVoiceControlMode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopRecognition();
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    ITtsListener _arg1 = ITtsListener.Stub.asInterface(data.readStrongBinder());
                    this.textToSpeech(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopSpeech();
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    this.getBeamFormerData();
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopBeamFormer();
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    GrammarConstraint _arg0 = 0 != data.readInt() ? (GrammarConstraint)GrammarConstraint.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.addGrammarConstraint(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    IRebuildGrammarListener _arg0 = IRebuildGrammarListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.rebuildGrammar(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    IRebuildGrammarListener _arg0 = IRebuildGrammarListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.resetAppGrammar(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    IRebuildGrammarListener _arg0 = IRebuildGrammarListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.resetSystemGrammar(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    GrammarConstraint _arg0 = 0 != data.readInt() ? (GrammarConstraint)GrammarConstraint.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.addSystemGrammarConstraint(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    IWakeupListener _arg0 = IWakeupListener.Stub.asInterface(data.readStrongBinder());
                    this.setApplicationWakeupListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    IWakeupListener _arg0 = IWakeupListener.Stub.asInterface(data.readStrongBinder());
                    this.setSystemWakeupListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    IRecognitionListener _arg0 = IRecognitionListener.Stub.asInterface(data.readStrongBinder());
                    this.setSystemRecognitionListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    IRecognitionListener _arg0 = IRecognitionListener.Stub.asInterface(data.readStrongBinder());
                    this.setApplicationRecognitionListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    this.enableBeamForming();
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    this.disableBeamForming();
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(DESCRIPTOR);
                    Version _result = this.getVersion();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IVoiceService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void registerApp() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void logoutApp() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireVoiceControlPermission(VoiceControlPermissionListener voiceControlPermissionListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(voiceControlPermissionListener != null ? voiceControlPermissionListener.asBinder() : null);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void releaseVoiceControlPermission() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCloudSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerVoiceServiceStateListener(VoiceServiceStateListener voiceServiceStateListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(voiceServiceStateListener != null ? voiceServiceStateListener.asBinder() : null);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initVoiceControlEngine(InitEngineListener initEngineListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(initEngineListener != null ? initEngineListener.asBinder() : null);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRawDataListener(IRawDataListener rawDataListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rawDataListener != null ? rawDataListener.asBinder() : null);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWakeup(IWakeupListener wakeupListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(wakeupListener != null ? wakeupListener.asBinder() : null);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRecognition(IRecognitionListener recognitionListener, boolean isLocal) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(recognitionListener != null ? recognitionListener.asBinder() : null);
                    _data.writeInt(isLocal ? 1 : 0);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void speechToText(IRecognitionListener recognitionListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(recognitionListener != null ? recognitionListener.asBinder() : null);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSimpleVoiceControlMode(IWakeupListener wakeupListener, IRecognitionListener recognitionListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(wakeupListener != null ? wakeupListener.asBinder() : null);
                    _data.writeStrongBinder(recognitionListener != null ? recognitionListener.asBinder() : null);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopRecognition() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void textToSpeech(String text, ITtsListener ttsListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(text);
                    _data.writeStrongBinder(ttsListener != null ? ttsListener.asBinder() : null);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopSpeech() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void getBeamFormerData() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopBeamFormer() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addGrammarConstraint(GrammarConstraint grammarConstraint) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (grammarConstraint != null) {
                        _data.writeInt(1);
                        grammarConstraint.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean rebuildGrammar(IRebuildGrammarListener rebuildGrammarListener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rebuildGrammarListener != null ? rebuildGrammarListener.asBinder() : null);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean resetAppGrammar(IRebuildGrammarListener rebuildGrammarListener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rebuildGrammarListener != null ? rebuildGrammarListener.asBinder() : null);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean resetSystemGrammar(IRebuildGrammarListener rebuildGrammarListener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rebuildGrammarListener != null ? rebuildGrammarListener.asBinder() : null);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addSystemGrammarConstraint(GrammarConstraint grammarConstraint) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (grammarConstraint != null) {
                        _data.writeInt(1);
                        grammarConstraint.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setApplicationWakeupListener(IWakeupListener wakeupListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(wakeupListener != null ? wakeupListener.asBinder() : null);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemWakeupListener(IWakeupListener wakeupListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(wakeupListener != null ? wakeupListener.asBinder() : null);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemRecognitionListener(IRecognitionListener systemRecognitionListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(systemRecognitionListener != null ? systemRecognitionListener.asBinder() : null);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setApplicationRecognitionListener(IRecognitionListener applicationRecognitionListener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(applicationRecognitionListener != null ? applicationRecognitionListener.asBinder() : null);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void enableBeamForming() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void disableBeamForming() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Version getVersion() throws RemoteException {
                Version _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Version)Version.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

