/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice;

import android.content.Context;
import android.support.annotation.NonNull;
import com.segway.robot.sdk.base.bind.BindController;
import com.segway.robot.sdk.base.bind.ForegroundBindController;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.voice.GrammarJsonValidator;
import com.segway.robot.sdk.voice.RecognizerManager;
import com.segway.robot.sdk.voice.VoiceException;
import com.segway.robot.sdk.voice.audiodata.RawDataListener;
import com.segway.robot.sdk.voice.grammar.GrammarConstraint;
import com.segway.robot.sdk.voice.recognition.RecognitionListener;
import com.segway.robot.sdk.voice.recognition.WakeupListener;

public class Recognizer {
    private static Recognizer mRecognizer;
    private RecognizerManager mRecognizerManager;
    private boolean mBindControllerInit;
    private BindController mBindController = new ForegroundBindController();

    private Recognizer() {
        this.mRecognizerManager = new RecognizerManager();
    }

    public static synchronized Recognizer getInstance() {
        if (mRecognizer == null) {
            mRecognizer = new Recognizer();
        }
        return mRecognizer;
    }

    public synchronized boolean bindService(@NonNull Context context, @NonNull ServiceBinder.BindStateListener listener) {
        if (!this.mBindControllerInit) {
            this.mBindControllerInit = true;
            this.mBindController.init(context, (ServiceBinder)this.mRecognizerManager);
        }
        if (this.mBindController.bindAcceptable()) {
            return this.mRecognizerManager.bindService(context, listener);
        }
        return false;
    }

    public synchronized void unbindService() {
        this.mRecognizerManager.unbindService();
    }

    public int getLanguage() throws VoiceException {
        return this.mRecognizerManager.getLanguage();
    }

    public void beamForming(boolean enable) throws VoiceException {
        this.mRecognizerManager.beamForming(enable);
    }

    public GrammarConstraint createGrammarConstraint(@NonNull String json) throws VoiceException {
        if (json.isEmpty() || json.equals("")) {
            throw new IllegalArgumentException("The input parameter cannot be empty!");
        }
        GrammarJsonValidator grammarJsonValidator = new GrammarJsonValidator();
        boolean legal = grammarJsonValidator.validate(json);
        if (!legal) {
            throw new VoiceException("The input JSON character string is illegal!");
        }
        return this.mRecognizerManager.createGrammarConstraint(json);
    }

    public void addGrammarConstraint(@NonNull GrammarConstraint grammarConstraint) throws VoiceException {
        this.mRecognizerManager.addGrammarConstraint(grammarConstraint);
    }

    public void removeGrammarConstraint(@NonNull GrammarConstraint grammarConstraint) throws VoiceException {
        this.mRecognizerManager.removeGrammarConstraint(grammarConstraint);
    }

    public void startRecognition(@NonNull WakeupListener wakeupListener, @NonNull RecognitionListener recognitionListener) throws VoiceException {
        this.mRecognizerManager.startRecognition(wakeupListener, recognitionListener);
    }

    public void stopRecognition() throws VoiceException {
        this.mRecognizerManager.stopRecognition();
    }

    public void startBeamFormingListen(@NonNull RawDataListener listener) throws VoiceException {
        this.mRecognizerManager.startBeamFormingListen(listener);
    }

    public void stopBeamFormingListen() throws VoiceException {
        this.mRecognizerManager.stopBeamFormingListen();
    }

    public void setSoundEnabled(boolean enabled) throws VoiceException {
        this.mRecognizerManager.setSoundEnabled(enabled);
    }
}

