package com.segway.robot.sdk.voice.recognition;

import android.os.Parcel;
import android.os.Parcelable;

public class RecognitionResult implements Parcelable {

    private String mRecognitionResult;
    private int mConfidence;
    private long mDuration;

    /**
     * Get the confidence of the recognition result.
     *
     * @return the confidence of the recognition result.
     */
    public int getConfidence() {
        return mConfidence;
    }

    /**
     * Get the result of the recognition.
     *
     * @return the result of the recognition.
     */
    public String getRecognitionResult() {
        return mRecognitionResult;
    }

    /**
     * Get the duration time of speech recognition.
     * @return duration time
     */
    public long getDuration() {
        return mDuration;
    }

    /**
     * Set the result of the recognition.
     *
     * @param recognitionResult the result of the recognition.
     */
    public void setRecognitionResult(String recognitionResult) {
        this.mRecognitionResult = recognitionResult;
    }

    /**
     * Set the confidence of the recognition.
     *
     * @param confidence the confidence of the recognition.
     */
    public void setConfidence(int confidence) {
        this.mConfidence = confidence;
    }

    /**
     * Set the duration time of the speech recognition.
     * @param duration the duration time of the speech recognition.
     */
    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    /**
     * The default constructor of the RecognitionResult class.
     */
    public RecognitionResult() {
    }

    /**
     * The parcel constructor of the RecognitionResult class.
     *
     * @param in The parcel where to read the recognition's result and confidence.
     */
    protected RecognitionResult(Parcel in) {
        mRecognitionResult = in.readString();
        mConfidence = in.readInt();
        mDuration = in.readLong();
    }

    /**
     * The constructor of the RecognitionResult class.
     *
     * @param result     the result of the recognition.
     * @param confidence the confidence of the recognition.
     */
    public RecognitionResult(String result, int confidence, long duration) {
        this.mRecognitionResult = result;
        this.mConfidence = confidence;
        this.mDuration = duration;
    }

    public static final Creator<RecognitionResult> CREATOR = new Creator<RecognitionResult>() {

        /**
         * Created a RecognitionResult instance from the data in the specified parcel.
         */
        @Override
        public RecognitionResult createFromParcel(Parcel in) {
            return new RecognitionResult(in);
        }

        /**
         * an array of RecognitionResult of the specified size.
         */
        @Override
        public RecognitionResult[] newArray(int size) {
            return new RecognitionResult[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mRecognitionResult);
        dest.writeInt(mConfidence);
        dest.writeLong(mDuration);
    }

    public void readFromParcel(Parcel in) {
        mRecognitionResult = in.readString();
        mConfidence = in.readInt();
        mDuration = in.readLong();
    }

    @Override
    public String toString() {
        return "RecognitionResult{" +
                "mRecognitionResult='" + mRecognitionResult + '\'' +
                ", mConfidence=" + mConfidence +
                ", mDuration=" + mDuration +
                '}';
    }
}
