package com.segway.robot.sdk.voice.recognition;

/**
 * A listener to be notified when a wake-up phrase is detected,
 * or the error description if an error occurs.
 */
public interface WakeupListener {
    /**
     * This method is called when the wake-up begins.
     */
    void onStandby();

    /**
     * This method is called when the wake-up succeeds.
     *
     * @param wakeupResult the {@link WakeupResult} of the wake-up.
     */
    void onWakeupResult(WakeupResult wakeupResult);

    /**
     * This method is called when the wake-up fails.
     *
     * @param error the reason of the failure.
     */
    void onWakeupError(String error);
}
