package com.segway.robot.sdk.voice.grammar;

import java.util.ArrayList;
import java.util.List;

public class GrammarCheckUtil {

    public static List<String> getAllGrammar(GrammarConstraint grammarConstraint) {
        List<String> slotString;
        List<Slot> slotList = grammarConstraint.getSlotList();
        int slotSize = slotList.size();
        slotString = slotList.get(0).getWordList();
        int current = 1;
        do {
            slotString = jointSlots(slotString, slotList.get(current));
            current++;
        } while (current < slotSize);
        return slotString;
    }

    private static List<String> jointSlots(List<String> foreContentList, Slot nextSlot) {
        List<String> grammar = new ArrayList<>();
        boolean nextSlotOpt = nextSlot.getOptional();
        int foreContentListSize = foreContentList.size();
        int nextSlotSize = nextSlot.getWordList().size();
        if (nextSlotOpt) {
            grammar.addAll(foreContentList);
        }
        List<String> nextSlotStringList = nextSlot.getWordList();
        for (int i = 0; i < foreContentListSize; i++) {
            for (int j = 0; j < nextSlotSize; j++) {
                grammar.add(foreContentList.get(i) + " " + nextSlotStringList.get(j));
            }
        }
        return grammar;
    }
}
