/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice.grammar;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.sdk.voice.grammar.Slot;
import java.util.ArrayList;
import java.util.List;

public class GrammarConstraint
implements Parcelable {
    private String mName;
    private List<Slot> mSlotList = new ArrayList<Slot>();
    public static final Parcelable.Creator<GrammarConstraint> CREATOR = new Parcelable.Creator<GrammarConstraint>(){

        public GrammarConstraint createFromParcel(Parcel in) {
            return new GrammarConstraint(in);
        }

        public GrammarConstraint[] newArray(int size) {
            return new GrammarConstraint[size];
        }
    };

    public GrammarConstraint() {
    }

    public GrammarConstraint(String name, List<Slot> slotList) {
        this.mName = name;
        this.mSlotList = slotList;
    }

    protected GrammarConstraint(Parcel in) {
        this.mName = in.readString();
        this.mSlotList = in.createTypedArrayList(Slot.CREATOR);
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setSlotList(List<Slot> slotList) {
        this.mSlotList = slotList;
    }

    public void addSlot(Slot slot) {
        this.mSlotList.add(slot);
    }

    public void addSlot(int location, Slot slot) {
        this.mSlotList.add(location, slot);
    }

    public void deleteSlot(Slot slot) {
        this.mSlotList.remove(slot);
    }

    public void deleteSlot(int location) {
        this.mSlotList.remove(location);
    }

    public String getName() {
        return this.mName;
    }

    public List<Slot> getSlotList() {
        return this.mSlotList;
    }

    public String toGrammarString() {
        if (this.mSlotList.isEmpty()) {
            throw new IllegalStateException("The slot list cannot be empty!");
        }
        StringBuilder grammarConstraintBuilder = new StringBuilder();
        for (Slot slot : this.mSlotList) {
            grammarConstraintBuilder.append(slot.toOptionalString());
        }
        return grammarConstraintBuilder.toString();
    }

    public void readFromParcel(Parcel in) {
        this.mName = in.readString();
        this.mSlotList = in.createTypedArrayList(Slot.CREATOR);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeTypedList(this.mSlotList);
    }
}

