package com.segway.robot.sdk.voice.recognition;

import android.os.Parcel;
import android.os.Parcelable;

public class WakeupResult implements Parcelable {
    private String mResult;
    private int mAngle;
    private long mDuration;

    /**
     * The parcel constructor of the WakeupResult class.
     *
     * @param in the parcel where to read the wake-up's result and angle.
     */
    protected WakeupResult(Parcel in) {
        mResult = in.readString();
        mAngle = in.readInt();
        mDuration = in.readLong();
    }

    /**
     * the constructor of the WakeupResult class.
     */
    public WakeupResult() {
        super();
    }

    /**
     * the constructor of the WakeupResult class.
     *
     * @param result the result of wake-up.
     * @param angle  the angle of wake-up orientation.
     */
    public WakeupResult(String result, int angle, long duration) {
        this.mResult = result;
        this.mAngle = angle;
        this.mDuration = duration;
    }

    public static final Creator<WakeupResult> CREATOR = new Creator<WakeupResult>() {

        /**
         * @return a new WakeupResult from the data in the specified parcel.
         */
        @Override
        public WakeupResult createFromParcel(Parcel in) {
            return new WakeupResult(in);
        }

        /**
         * @return an array of WakeupResult of the specified size.
         */
        @Override
        public WakeupResult[] newArray(int size) {
            return new WakeupResult[size];
        }
    };

    /**
     * Set the result of wake-up.
     *
     * @param result the result of wake-up.
     */
    public void setResult(String result) {
        this.mResult = result;
    }

    /**
     * Set the angle of wake-up.
     *
     * @param angle the angle of wake-up.
     */
    public void setAngle(int angle) {
        this.mAngle = angle;
    }

    /**
     * Set the duration time of wake-up.
     * @param duration the duration time of wake-up.
     */
    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    /**
     * Get the result of wake-up.
     *
     * @return the result of wake-up.
     */
    public String getResult() {
        return this.mResult;
    }

    /**
     * Get the angle of wake-up.
     *
     * @return the angle of wake-up.
     */
    public int getAngle() {
        return this.mAngle;
    }

    /**
     * Get the duration time of wake-up.
     * @return the duration time of wake-up.
     */
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mResult);
        dest.writeInt(mAngle);
        dest.writeLong(mDuration);
    }

    /**
     * Read the result and the angle of the wake-up from the data in the specified parcel.
     *
     * @param in the parcel where to read the wake-up's result and angle.
     */
    public void readFromParcel(Parcel in) {
        mResult = in.readString();
        mAngle = in.readInt();
        mDuration = in.readLong();
    }
}
