/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.perception.sensor;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.segway.robot.sdk.base.bind.BlankBindController;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.base.version.VersionMismatchException;
import com.segway.robot.sdk.perception.sensor.IRobotSensorService;
import com.segway.robot.sdk.perception.sensor.InfraredData;
import com.segway.robot.sdk.perception.sensor.RobotSensorException;
import com.segway.robot.sdk.perception.sensor.RobotTotalInfo;
import com.segway.robot.sdk.perception.sensor.UltrasonicData;
import com.segway.robot.sdk.perception.sensor.UwbEvent;
import com.segway.robot.sdk.perception.sensor.VersionInfo;

public class Sensor
implements ServiceBinder {
    private static final String TAG = "Sensor";
    private static final String SERVICE_CLASS_NAME = "com.segway.robot.host.coreservice.locomotionservice.RobotSensorService";
    private static final String SERVICE_PACKAGE_NAME = "com.segway.robot.host.coreservice.locomotionservice";
    private static Sensor mSensor;
    private IRobotSensorService mIRobotSensorService;
    private ServiceBinder.BindStateListener mBindStateListener;
    public static final int UWB_NAVIGATION_MODE = 0;
    public static final int UWB_FOLLOW_MODE = 1;
    ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Sensor.this.mIRobotSensorService = IRobotSensorService.Stub.asInterface(service);
            Version version = VersionInfo.getVersion();
            try {
                Version serviceVersion = Sensor.this.mIRobotSensorService.getVersion();
                version.check("VersionInfo", serviceVersion);
            }
            catch (RemoteException e) {
                String error = "Cannot get Service version, err = " + e.getMessage();
                Sensor.this.bindError((Exception)((Object)e), error);
                return;
            }
            catch (VersionMismatchException e) {
                String error = "Version mismatch: " + e.getMessage();
                Sensor.this.bindError((Exception)((Object)e), error);
                return;
            }
            Sensor.this.mBindStateListener.onBind();
        }

        public void onServiceDisconnected(ComponentName name) {
            Sensor.this.mIRobotSensorService = null;
            Sensor.this.mBindStateListener.onUnbind("Service Disconnected");
        }
    };
    private Context mContext;
    private boolean isBind = false;
    private boolean isControllerSet = false;

    private Sensor() {
    }

    public static synchronized Sensor getInstance() {
        if (mSensor == null) {
            mSensor = new Sensor();
        }
        return mSensor;
    }

    public synchronized boolean connectService(Context context) {
        Intent serviceIntent = new Intent();
        serviceIntent.setAction(SERVICE_CLASS_NAME);
        serviceIntent.setPackage(SERVICE_PACKAGE_NAME);
        serviceIntent.setClassName(SERVICE_PACKAGE_NAME, SERVICE_CLASS_NAME);
        return context.bindService(serviceIntent, this.mServiceConnection, 1);
    }

    public synchronized boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        if (context == null || listener == null) {
            throw new IllegalArgumentException("context and listener can't null");
        }
        if (this.isBind) {
            return true;
        }
        this.mBindStateListener = listener;
        if (!this.isControllerSet) {
            this.isControllerSet = true;
            new BlankBindController().init(context, (ServiceBinder)this);
        }
        this.mContext = context.getApplicationContext();
        this.isBind = this.connectService(this.mContext);
        return this.isBind;
    }

    public synchronized void unbindService() {
        if (!this.isBind) {
            return;
        }
        this.isBind = false;
        this.mContext.unbindService(this.mServiceConnection);
    }

    public boolean isBind() {
        return this.isBind;
    }

    public ServiceBinder.BindStateListener getBindStateListener() {
        return this.mBindStateListener;
    }

    public UltrasonicData getUltrasonicDistance() {
        try {
            return this.mIRobotSensorService.getUltrasonicDistance();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new RobotSensorException("getUltrasonicDistance error", e);
        }
    }

    public InfraredData getInfraredDistance() {
        try {
            return this.mIRobotSensorService.getInfraredDistance();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new RobotSensorException("getInfraredDistance error", e);
        }
    }

    public RobotTotalInfo getRobotTotalInfo() {
        try {
            return this.mIRobotSensorService.getRobotTotalInfo();
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getRobotTotalInfo error", e);
        }
    }

    public UwbEvent getUwbEvent() {
        try {
            return this.mIRobotSensorService.getUwbEvent();
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getRobotTotalInfo error", e);
        }
    }

    private void bindError(Exception e, String error) {
        this.mBindStateListener.onUnbind(error);
        Logger.e((String)TAG, (String)error, (Throwable)e);
        this.isBind = false;
        this.mContext.unbindService(this.mServiceConnection);
    }

    public void setUwbMode(int mode) {
        try {
            this.mIRobotSensorService.setUwbMode(mode);
        }
        catch (RemoteException e) {
            throw new RobotSensorException("setUwbMode error", e);
        }
    }

    public int getUwbMode() {
        try {
            return this.mIRobotSensorService.getUwbMode();
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getUwbMode error", e);
        }
    }

    public UwbEvent[] getUwbEventArray() {
        try {
            return this.mIRobotSensorService.getUwbEventArray();
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getUwbEventArray error", e);
        }
    }
}

