/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.sdk.base.time.StampedData;

public class InfraredData
implements StampedData,
Parcelable {
    public static final Parcelable.Creator<InfraredData> CREATOR = new Parcelable.Creator<InfraredData>(){

        public InfraredData createFromParcel(Parcel in) {
            return new InfraredData(in);
        }

        public InfraredData[] newArray(int size) {
            return new InfraredData[size];
        }
    };
    long mTimestamp;
    float mLeftDistance;
    float mRightDistance;

    public InfraredData(long timestamp, float leftDistance, float rightDistance) {
        this.mTimestamp = timestamp;
        this.mLeftDistance = leftDistance;
        this.mRightDistance = rightDistance;
    }

    protected InfraredData(Parcel in) {
        this.mTimestamp = in.readLong();
        this.mLeftDistance = in.readFloat();
        this.mRightDistance = in.readFloat();
    }

    public float getLeftDistance() {
        return this.mLeftDistance;
    }

    public float getRightDistance() {
        return this.mRightDistance;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimestamp);
        dest.writeFloat(this.mLeftDistance);
        dest.writeFloat(this.mRightDistance);
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public long diff(StampedData source) {
        return source.getTimestamp() - this.mTimestamp;
    }

    public String toString() {
        return "InfraredData{timestamp=" + this.mTimestamp + ", leftDistance=" + this.mLeftDistance + ", rightDistance=" + this.mRightDistance + '}';
    }
}

