package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.algo.Pose2D;
import com.segway.robot.sdk.locomotion.head.Angle;
import com.segway.robot.sdk.locomotion.sbv.BasePose;
import com.segway.robot.sdk.locomotion.sbv.BaseTicks;

/**
 * Created by ark338 on 2016/11/20.
 */

public class RobotTotalInfo implements Parcelable{
    private final Angle mHeadWorldYaw;
    private final Angle mHeadWorldPitch;
    private final Angle mHeadWorldRoll;
    private final Angle mHeadJointYaw;
    private final Angle mHeadJointPitch;
    private final Angle mHeadJointRoll;
    private final BaseTicks mBaseTicks;
    private final UltrasonicData mUltrasonicData;
    private final InfraredData mInfraredData;
    private final BasePose mBasePose;
    private final UwbEvent mUwbEvent;
    private final Pose2D mPose2D;

    public RobotTotalInfo(Angle headWorldYaw, Angle headWorldPitch, Angle headWorldRoll,
                          Angle headJointYaw, Angle headJointPitch, Angle headJointRoll,
                          BaseTicks baseTicks, UltrasonicData ultrasonicData,
                          InfraredData infraredData, BasePose basePose, UwbEvent uwbEvent,
                          Pose2D pose2D) {
        mHeadWorldYaw = headWorldYaw;
        mHeadWorldPitch = headWorldPitch;
        mHeadWorldRoll = headWorldRoll;
        mHeadJointYaw = headJointYaw;
        mHeadJointPitch = headJointPitch;
        mHeadJointRoll = headJointRoll;
        mBaseTicks = baseTicks;
        mUltrasonicData = ultrasonicData;
        mInfraredData = infraredData;
        mBasePose = basePose;
        mUwbEvent = uwbEvent;
        mPose2D = pose2D;
    }

    protected RobotTotalInfo(Parcel in) {
        mHeadWorldYaw = in.readParcelable(Angle.class.getClassLoader());
        mHeadWorldPitch = in.readParcelable(Angle.class.getClassLoader());
        mHeadWorldRoll = in.readParcelable(Angle.class.getClassLoader());
        mHeadJointYaw = in.readParcelable(Angle.class.getClassLoader());
        mHeadJointPitch = in.readParcelable(Angle.class.getClassLoader());
        mHeadJointRoll = in.readParcelable(Angle.class.getClassLoader());
        mBaseTicks = in.readParcelable(BaseTicks.class.getClassLoader());
        mUltrasonicData = in.readParcelable(UltrasonicData.class.getClassLoader());
        mInfraredData = in.readParcelable(InfraredData.class.getClassLoader());
        mBasePose = in.readParcelable(BasePose.class.getClassLoader());
        mUwbEvent = in.readParcelable(UwbEvent.class.getClassLoader());
        mPose2D = in.readParcelable(Pose2D.class.getClassLoader());
    }

    public static final Creator<RobotTotalInfo> CREATOR = new Creator<RobotTotalInfo>() {
        @Override
        public RobotTotalInfo createFromParcel(Parcel in) {
            return new RobotTotalInfo(in);
        }

        @Override
        public RobotTotalInfo[] newArray(int size) {
            return new RobotTotalInfo[size];
        }
    };

    public Angle getHeadWorldYaw() {
        return mHeadWorldYaw;
    }

    public Angle getHeadWorldPitch() {
        return mHeadWorldPitch;
    }

    public Angle getHeadWorldRoll() {
        return mHeadWorldRoll;
    }

    public Angle getHeadJointYaw() {
        return mHeadJointYaw;
    }

    public Angle getHeadJointPitch() {
        return mHeadJointPitch;
    }

    public Angle getHeadJointRoll() {
        return mHeadJointRoll;
    }

    public BaseTicks getBaseTicks() {
        return mBaseTicks;
    }

    public UltrasonicData getUltrasonicData() {
        return mUltrasonicData;
    }

    public InfraredData getInfraredData() {
        return mInfraredData;
    }

    public BasePose getBasePose() {
        return mBasePose;
    }

    public UwbEvent getUwbEvent() {
        return mUwbEvent;
    }

    public Pose2D getPose2D() {
        return mPose2D;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(mHeadWorldYaw, flags);
        dest.writeParcelable(mHeadWorldPitch, flags);
        dest.writeParcelable(mHeadWorldRoll, flags);
        dest.writeParcelable(mHeadJointYaw, flags);
        dest.writeParcelable(mHeadJointPitch, flags);
        dest.writeParcelable(mHeadJointRoll, flags);
        dest.writeParcelable(mBaseTicks, flags);
        dest.writeParcelable(mUltrasonicData, flags);
        dest.writeParcelable(mInfraredData, flags);
        dest.writeParcelable(mBasePose, flags);
        dest.writeParcelable(mUwbEvent, flags);
        dest.writeParcelable(mPose2D, flags);
    }

    @Override
    public String toString() {
        return "RobotTotalInfo:" +
                " HeadWorldYaw=" + mHeadWorldYaw +
                ", HeadWorldPitch=" + mHeadWorldPitch +
                ", HeadWorldRoll=" + mHeadWorldRoll +
                ", HeadJointYaw=" + mHeadJointYaw +
                ", HeadJointPitch=" + mHeadJointPitch +
                ", HeadJointRoll=" + mHeadJointRoll +
                ", BaseTicks=" + mBaseTicks +
                ", UltrasonicData=" + mUltrasonicData +
                ", InfraredData=" + mInfraredData +
                ", BasePose=" + mBasePose +
                ", UwbEvent=" + mUwbEvent +
                ", Pose2D=" + mPose2D;
    }
}
