package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

/**
 * Created by ark338 on 2016/11/18.
 */
public class UwbEvent implements StampedData, Parcelable{
    private final long timestamp;
    private final int id;
    private final float direction;
    private final float distance;
    private final float confidence;

    public UwbEvent(long timestamp, int id, int direction, int distance, int confidence) {
        this.timestamp = timestamp;
        this.id = id;
        this.direction = (float) Math.toRadians(-direction/10);
        this.distance = ((float) distance / 1000);
        this.confidence = confidence;
    }

    // for legacy use
    public UwbEvent(int direction, int distance, int confidence) {
        this.timestamp = System.currentTimeMillis();
        this.id = 0;
        this.direction = (float) Math.toRadians(-direction/10);
        this.distance = ((float) distance / 1000);
        this.confidence = confidence;
    }

    protected UwbEvent(Parcel in) {
        timestamp = in.readLong();
        id = in.readInt();
        direction = in.readFloat();
        distance = in.readFloat();
        confidence = in.readFloat();
    }

    public static final Creator<UwbEvent> CREATOR = new Creator<UwbEvent>() {
        @Override
        public UwbEvent createFromParcel(Parcel in) {
            return new UwbEvent(in);
        }

        @Override
        public UwbEvent[] newArray(int size) {
            return new UwbEvent[size];
        }
    };

    public float getDirection() {
        return direction;
    }

    public float getDistance() {
        return distance;
    }

    public float getConfidence() {
        return confidence;
    }

    public int getId() {
        return id;
    }

    @Override
    public String toString() {
        return "UwbEvent:" +
                " timestamp=" + timestamp +
                " id=" + id +
                " direction=" + direction +
                " distance=" + distance +
                " confidence=" + confidence;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(timestamp);
        dest.writeInt(id);
        dest.writeFloat(direction);
        dest.writeFloat(distance);
        dest.writeFloat(confidence);
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - timestamp;
    }
}
