package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

import java.util.Arrays;

/**
 * Created by sgs on 2017/12/11.
 */

public class SensorData implements StampedData, Parcelable {
    /**
     * {@link Sensor#G1_INFRARED} all values are in mm units.
     *  values[0]:left infrared data.
     *  values[1]:right infrared data
     * {@link Sensor#G1_ULTRASONIC} all values are in mm units.
     * values[0]:G1 ultrasonic data.
     */
    float data;
    int type;
    long timestamp;
    float floatData[];
    int intData[];
    long longData[];
    boolean booleanData[];

    public SensorData() {
    }

    protected SensorData(Parcel in) {
        data = in.readFloat();
        type = in.readInt();
        timestamp = in.readLong();
        floatData = in.createFloatArray();
        intData = in.createIntArray();
        longData = in.createLongArray();
        booleanData = in.createBooleanArray();
    }

    public static final Creator<SensorData> CREATOR = new Creator<SensorData>() {
        @Override
        public SensorData createFromParcel(Parcel in) {
            return new SensorData(in);
        }

        @Override
        public SensorData[] newArray(int size) {
            return new SensorData[size];
        }
    };

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - timestamp;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(data);
        dest.writeInt(type);
        dest.writeLong(timestamp);
        dest.writeFloatArray(floatData);
        dest.writeIntArray(intData);
        dest.writeLongArray(longData);
        dest.writeBooleanArray(booleanData);
    }

    public float getData() {
        return data;
    }

    public void setData(float data) {
        this.data = data;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public float[] getFloatData() {
        return floatData;
    }

    public void setFloatData(float[] floatData) {
        this.floatData = floatData;
    }

    public int[] getIntData() {
        return intData;
    }

    public void setIntData(int[] intData) {
        this.intData = intData;
    }

    public long[] getLongData() {
        return longData;
    }

    public void setLongData(long[] longData) {
        this.longData = longData;
    }

    public boolean[] getBooleanData() {
        return booleanData;
    }

    public void setBooleanData(boolean[] booleanData) {
        this.booleanData = booleanData;
    }

    @Override
    public String toString() {
        return "SensorData{" +
                ", type=" + type +
                ", timestamp=" + timestamp +
                ", floatData=" + Arrays.toString(floatData) +
                ", intData=" + Arrays.toString(intData) +
                ", longData=" + Arrays.toString(longData) +
                '}';
    }


}
