/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.perception.sensor;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.segway.robot.algo.tf.AlgoTfData;
import com.segway.robot.algo.tf.AlgoTfRequest;
import com.segway.robot.sdk.base.bind.ForegroundBindController;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.base.version.VersionMismatchException;
import com.segway.robot.sdk.perception.sensor.IRobotSensorService;
import com.segway.robot.sdk.perception.sensor.ISensor;
import com.segway.robot.sdk.perception.sensor.InfraredData;
import com.segway.robot.sdk.perception.sensor.RobotAllSensors;
import com.segway.robot.sdk.perception.sensor.RobotSensorException;
import com.segway.robot.sdk.perception.sensor.RobotTotalInfo;
import com.segway.robot.sdk.perception.sensor.SensorData;
import com.segway.robot.sdk.perception.sensor.UltrasonicData;
import com.segway.robot.sdk.perception.sensor.VersionInfo;
import com.segway.robot.sdk.perception.sensor.gx.GxBodySensor;
import com.segway.robot.sdk.perception.sensor.gx.GxBumper;
import com.segway.robot.sdk.perception.sensor.gx.GxInfrared;
import java.util.List;

class SensorManager
extends ISensor
implements ServiceBinder {
    private static final String TAG = "SensorManager";
    private static final String SERVICE_CLASS_NAME = "com.segway.robot.host.coreservice.locomotionservice.RobotSensorService";
    private static final String SERVICE_PACKAGE_NAME = "com.segway.robot.host.coreservice.locomotionservice";
    private IRobotSensorService mIRobotSensorService;
    private ServiceBinder.BindStateListener mBindStateListener;
    private Context mContext;
    private boolean isBind = false;
    private boolean isControllerSet = false;
    ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            SensorManager.this.mIRobotSensorService = IRobotSensorService.Stub.asInterface(service);
            Version version = VersionInfo.getVersion();
            try {
                Version serviceVersion = SensorManager.this.mIRobotSensorService.getVersion();
                version.check("VersionInfo", serviceVersion);
            }
            catch (RemoteException e) {
                String error = "Cannot get Service version, err = " + e.getMessage();
                SensorManager.this.bindError((Exception)((Object)e), error);
                return;
            }
            catch (VersionMismatchException e) {
                String error = "Version mismatch: " + e.getMessage();
                SensorManager.this.bindError((Exception)((Object)e), error);
                return;
            }
            SensorManager.this.mBindStateListener.onBind();
            SensorManager.this.isBind = true;
        }

        public void onServiceDisconnected(ComponentName name) {
            SensorManager.this.mIRobotSensorService = null;
            SensorManager.this.mBindStateListener.onUnbind("Service Disconnected");
            SensorManager.this.isBind = false;
        }
    };

    SensorManager() {
    }

    synchronized boolean connectService(Context context) {
        Intent serviceIntent = new Intent();
        serviceIntent.setAction(SERVICE_CLASS_NAME);
        serviceIntent.setPackage(SERVICE_PACKAGE_NAME);
        serviceIntent.setClassName(SERVICE_PACKAGE_NAME, SERVICE_CLASS_NAME);
        return context.bindService(serviceIntent, this.mServiceConnection, 1);
    }

    private void bindError(Exception e, String error) {
        this.mBindStateListener.onUnbind(error);
        Logger.e((String)TAG, (String)error, (Throwable)e);
        this.isBind = false;
        this.mContext.unbindService(this.mServiceConnection);
    }

    public boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        if (context == null || listener == null) {
            throw new IllegalArgumentException("context and listener can't null");
        }
        if (this.isBind) {
            return true;
        }
        this.mBindStateListener = listener;
        if (!this.isControllerSet) {
            this.isControllerSet = true;
            new ForegroundBindController().init(context, (ServiceBinder)this);
        }
        this.mContext = context.getApplicationContext();
        return this.connectService(this.mContext);
    }

    public void unbindService() {
        if (!this.isBind) {
            return;
        }
        this.isBind = false;
        this.mContext.unbindService(this.mServiceConnection);
    }

    public boolean isBind() {
        return this.isBind;
    }

    public ServiceBinder.BindStateListener getBindStateListener() {
        return this.mBindStateListener;
    }

    @Override
    UltrasonicData getUltrasonicDistance() {
        try {
            return this.mIRobotSensorService.getUltrasonicDistance();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new RobotSensorException("getUltrasonicDistance error", e);
        }
    }

    @Override
    InfraredData getInfraredDistance() {
        try {
            return this.mIRobotSensorService.getInfraredDistance();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new RobotSensorException("getInfraredDistance error", e);
        }
    }

    @Override
    RobotTotalInfo getRobotTotalInfo() {
        try {
            return this.mIRobotSensorService.getRobotTotalInfo();
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getRobotTotalInfo error", e);
        }
    }

    @Override
    AlgoTfData getTfData(String tgt, String src, long lookupTimestamp, int timeTrhMs) {
        try {
            return this.mIRobotSensorService.getTfData(tgt, src, lookupTimestamp, timeTrhMs);
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getTfData error", e);
        }
    }

    @Override
    AlgoTfData getTfData(AlgoTfRequest req) {
        try {
            return this.mIRobotSensorService.getTfData2(req);
        }
        catch (RemoteException e) {
            throw new RobotSensorException("get TfData2 error", e);
        }
    }

    @Override
    List<AlgoTfData> getMassiveTfData(List<AlgoTfRequest> requestList) {
        try {
            return this.mIRobotSensorService.getMassiveTfData(requestList);
        }
        catch (RemoteException e) {
            throw new RobotSensorException("get massive TfData error", e);
        }
    }

    @Override
    boolean setCustomizationTF(AlgoTfData tfData) {
        try {
            Log.d((String)TAG, (String)("setCustomizationTF: " + tfData.toString()));
            return this.mIRobotSensorService.setCustmizitionTF(tfData);
        }
        catch (RemoteException e) {
            throw new RobotSensorException("set Customization tf error", e);
        }
    }

    @Override
    RobotAllSensors getRobotAllSensors() {
        try {
            return this.mIRobotSensorService.getRobotAllSensors();
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getRobotAllSensors error", e);
        }
    }

    @Override
    SensorData[] getSensorData(int type) {
        try {
            return this.mIRobotSensorService.getSensorData(type);
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getSensorData error", e);
        }
    }

    @Override
    GxBodySensor getGxBodySensor() {
        try {
            return this.mIRobotSensorService.getGxBodySensor();
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getGxBodySensor error", e);
        }
    }

    @Override
    GxBumper getGxBumper() {
        try {
            return this.mIRobotSensorService.getGxBumper();
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getGxBumper error", e);
        }
    }

    @Override
    GxInfrared getGxInfrared(int type) {
        try {
            return this.mIRobotSensorService.getGxInfrared(type);
        }
        catch (RemoteException e) {
            throw new RobotSensorException("getGxInfrared error", e);
        }
    }
}

