/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.perception.sensor;

import android.content.Context;
import com.segway.robot.algo.tf.AlgoTfData;
import com.segway.robot.algo.tf.AlgoTfRequest;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.perception.sensor.ISensor;
import com.segway.robot.sdk.perception.sensor.InfraredData;
import com.segway.robot.sdk.perception.sensor.RobotAllSensors;
import com.segway.robot.sdk.perception.sensor.RobotTotalInfo;
import com.segway.robot.sdk.perception.sensor.SensorData;
import com.segway.robot.sdk.perception.sensor.SensorManager;
import com.segway.robot.sdk.perception.sensor.UltrasonicData;
import com.segway.robot.sdk.perception.sensor.gx.GxBodySensor;
import com.segway.robot.sdk.perception.sensor.gx.GxBumper;
import com.segway.robot.sdk.perception.sensor.gx.GxInfrared;
import java.util.List;

public class Sensor
extends ISensor
implements ServiceBinder {
    private static final String TAG = "Sensor";
    private static Sensor mSensor;
    public static final int G1_INFRARED = 0;
    public static final int G1_ULTRASONIC = 1;
    public static final String WORLD_ODOM_ORIGIN = "world_odom_frame";
    public static final String WORLD_EVIO_ORIGIN = "world_evio_frame";
    public static final String BASE_ODOM_FRAME = "base_center_ground_frame";
    public static final String BASE_POSE_FRAME = "base_center_wheel_axis_frame";
    public static final String NECK_POSE_FRAME = "neck_center_body_internal_frame";
    public static final String HEAD_POSE_Y_FRAME = "neck_center_body_yaw_frame";
    public static final String HEAD_POSE_P_FRAME = "head_center_neck_internal_frame";
    public static final String RS_DEPTH_FRAME = "rsdepth_center_neck_fix_frame";
    public static final String RS_FE_FRAME = "rsfisheye_center_neck_fix_frame";
    public static final String RS_COLOR_FRAME = "rscolor_center_neck_fix_frame";
    public static final String HEAD_POSE_P_R_FRAME = "head_center_neck_pitch_frame";
    public static final String PLATFORM_CAM_FRAME = "platform_center_head_fix_frame";
    SensorManager mSensorManager = new SensorManager();

    private Sensor() {
    }

    public static synchronized Sensor getInstance() {
        if (mSensor == null) {
            mSensor = new Sensor();
        }
        return mSensor;
    }

    @Override
    public UltrasonicData getUltrasonicDistance() {
        return this.mSensorManager.getUltrasonicDistance();
    }

    @Override
    public InfraredData getInfraredDistance() {
        return this.mSensorManager.getInfraredDistance();
    }

    @Override
    @Deprecated
    public RobotTotalInfo getRobotTotalInfo() {
        return this.mSensorManager.getRobotTotalInfo();
    }

    @Override
    public AlgoTfData getTfData(String targetFrame, String sourceFrame, long lookupTimestamp, int timeTrhMs) {
        return this.mSensorManager.getTfData(targetFrame, sourceFrame, lookupTimestamp, timeTrhMs);
    }

    @Override
    public AlgoTfData getTfData(AlgoTfRequest req) {
        return this.mSensorManager.getTfData(req);
    }

    @Override
    public List<AlgoTfData> getMassiveTfData(List<AlgoTfRequest> requestList) {
        return this.mSensorManager.getMassiveTfData(requestList);
    }

    @Override
    public boolean setCustomizationTF(AlgoTfData tfData) {
        return this.mSensorManager.setCustomizationTF(tfData);
    }

    @Override
    public RobotAllSensors getRobotAllSensors() {
        return this.mSensorManager.getRobotAllSensors();
    }

    @Override
    public SensorData[] getSensorData(int type) {
        return this.mSensorManager.getSensorData(type);
    }

    @Override
    public GxBodySensor getGxBodySensor() {
        return this.mSensorManager.getGxBodySensor();
    }

    @Override
    public GxBumper getGxBumper() {
        return this.mSensorManager.getGxBumper();
    }

    @Override
    public GxInfrared getGxInfrared(int type) {
        return this.mSensorManager.getGxInfrared(type);
    }

    public boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        return this.mSensorManager.bindService(context, listener);
    }

    public void unbindService() {
        this.mSensorManager.unbindService();
    }

    public boolean isBind() {
        return this.mSensorManager.isBind();
    }

    public ServiceBinder.BindStateListener getBindStateListener() {
        return this.mSensorManager.getBindStateListener();
    }
}

