package com.segway.robot.sdk.perception.sensor.gx;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

/**
 * Created by sgs on 2017/12/26.
 */

public class GxInfrared implements StampedData, Parcelable {
    long timestamp;
    int infrared0;
    int infrared1;
    int infrared2;
    int infrared3;

    public GxInfrared(long timestamp, int infrared0, int infrared1, int infrared2, int infrared3) {
        this.timestamp = timestamp;
        this.infrared0 = infrared0;
        this.infrared1 = infrared1;
        this.infrared2 = infrared2;
        this.infrared3 = infrared3;
    }

    protected GxInfrared(Parcel in) {
        timestamp = in.readLong();
        infrared0 = in.readInt();
        infrared1 = in.readInt();
        infrared2 = in.readInt();
        infrared3 = in.readInt();
    }

    public static final Creator<GxInfrared> CREATOR = new Creator<GxInfrared>() {
        @Override
        public GxInfrared createFromParcel(Parcel in) {
            return new GxInfrared(in);
        }

        @Override
        public GxInfrared[] newArray(int size) {
            return new GxInfrared[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(timestamp);
        dest.writeInt(infrared0);
        dest.writeInt(infrared1);
        dest.writeInt(infrared2);
        dest.writeInt(infrared3);
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - timestamp;
    }

    @Override
    public String toString() {
        return "GxInfrared{" +
                "timestamp=" + timestamp +
                ", infrared0=" + infrared0 +
                ", infrared1=" + infrared1 +
                ", infrared2=" + infrared2 +
                ", infrared3=" + infrared3 +
                '}';
    }
}
