package com.segway.robot.sdk.perception.sensor.gx;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

/**
 * Created by sgs on 2017/12/26.
 */

public class GxBumper implements StampedData, Parcelable {
    long timestamp;
    int bumper0;
    int bumper1;
    int bumper2;
    int bumper3;

    public GxBumper(long timestamp, int bumper0, int bumper1, int bumper2, int bumper3) {
        this.timestamp = timestamp;
        this.bumper0 = bumper0;
        this.bumper1 = bumper1;
        this.bumper2 = bumper2;
        this.bumper3 = bumper3;
    }

    protected GxBumper(Parcel in) {
        timestamp = in.readLong();
        bumper0 = in.readInt();
        bumper1 = in.readInt();
        bumper2 = in.readInt();
        bumper3 = in.readInt();
    }

    public static final Creator<GxBumper> CREATOR = new Creator<GxBumper>() {
        @Override
        public GxBumper createFromParcel(Parcel in) {
            return new GxBumper(in);
        }

        @Override
        public GxBumper[] newArray(int size) {
            return new GxBumper[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(timestamp);
        dest.writeInt(bumper0);
        dest.writeInt(bumper1);
        dest.writeInt(bumper2);
        dest.writeInt(bumper3);
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - timestamp;
    }

    @Override
    public String toString() {
        return "GxBumper{" +
                "timestamp=" + timestamp +
                ", bumper0=" + bumper0 +
                ", bumper1=" + bumper1 +
                ", bumper2=" + bumper2 +
                ", bumper3=" + bumper3 +
                '}';
    }
}
