package com.segway.robot.sdk.perception.sensor.gx;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

/**
 * Created by sgs on 2017/12/26.
 */

public class GxBodySensor implements StampedData, Parcelable {
    long timestamp;
    int ultrasonic;
    int bodyInfrared0;
    int bodyInfrared1;

    public GxBodySensor(long timestamp, int ultrasonic, int bodyInfrared0, int bodyInfrared1) {
        this.timestamp = timestamp;
        this.ultrasonic = ultrasonic;
        this.bodyInfrared0 = bodyInfrared0;
        this.bodyInfrared1 = bodyInfrared1;
    }

    protected GxBodySensor(Parcel in) {
        timestamp = in.readLong();
        ultrasonic = in.readInt();
        bodyInfrared0 = in.readInt();
        bodyInfrared1 = in.readInt();
    }

    public static final Creator<GxBodySensor> CREATOR = new Creator<GxBodySensor>() {
        @Override
        public GxBodySensor createFromParcel(Parcel in) {
            return new GxBodySensor(in);
        }

        @Override
        public GxBodySensor[] newArray(int size) {
            return new GxBodySensor[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(timestamp);
        dest.writeInt(ultrasonic);
        dest.writeInt(bodyInfrared0);
        dest.writeInt(bodyInfrared1);
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public long diff(StampedData source) {
        return 0;
    }

    @Override
    public String toString() {
        return "GxBodySensor{" +
                "timestamp=" + timestamp +
                ", ultrasonic=" + ultrasonic +
                ", bodyInfrared0=" + bodyInfrared0 +
                ", bodyInfrared1=" + bodyInfrared1 +
                '}';
    }
}
