package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

/**
 * Created by sgs on 2017/12/11.
 */

public class SensorData implements StampedData, Parcelable {
    /**
     * {@link Sensor#G1_INFRARED} all values are in mm units.
     *  values[0]:left infrared data.
     *  values[1]:right infrared data
     * {@link Sensor#G1_ULTRASONIC} all values are in mm units.
     * values[0]:G1 ultrasonic data.
     */
    long timestamp;
    float data;

    public SensorData(long timestamp, float data) {
        this.timestamp = timestamp;
        this.data = data;
    }

    protected SensorData(Parcel in) {
        timestamp = in.readLong();
        data = in.readFloat();
    }

    public static final Creator<SensorData> CREATOR = new Creator<SensorData>() {
        @Override
        public SensorData createFromParcel(Parcel in) {
            return new SensorData(in);
        }

        @Override
        public SensorData[] newArray(int size) {
            return new SensorData[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(timestamp);
        dest.writeFloat(data);
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    public float getData() {
        return data;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - timestamp;
    }

    @Override
    public String toString() {
        return "SensorData{" +
                "timestamp=" + timestamp +
                ", data=" + data +
                '}';
    }
}
