package com.segway.robot.sdk.perception.sensor;


import android.content.Context;

import com.segway.robot.algo.tf.AlgoTfData;
import com.segway.robot.algo.tf.AlgoTfRequest;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.perception.sensor.gx.GxBodySensor;
import com.segway.robot.sdk.perception.sensor.gx.GxBumper;
import com.segway.robot.sdk.perception.sensor.gx.GxInfrared;

import java.util.LinkedList;
import java.util.List;


/**
 * The manager is used to get the robot's sensor status, include ultrasonic distance infrared distance
 * and tf data.
 */
public class Sensor extends ISensor implements ServiceBinder {
    private static final String TAG = "Sensor";
    private static Sensor mSensor;


    public static final int G1_INFRARED = 0;
    public static final int G1_ULTRASONIC = 1 ;

    // robot frame name for get tf frame data
    public static final String WORLD_ODOM_ORIGIN = "world_odom_frame";
    public static final String WORLD_EVIO_ORIGIN = "world_evio_frame";
    public static final String BASE_ODOM_FRAME = "base_center_ground_frame";
    public static final String BASE_POSE_FRAME = "base_center_wheel_axis_frame";
    public static final String NECK_POSE_FRAME = "neck_center_body_internal_frame";
    public static final String HEAD_POSE_Y_FRAME = "neck_center_body_yaw_frame";
    public static final String HEAD_POSE_P_FRAME = "head_center_neck_internal_frame";
    public static final String RS_DEPTH_FRAME = "rsdepth_center_neck_fix_frame";
    public static final String RS_FE_FRAME = "rsfisheye_center_neck_fix_frame";
    public static final String RS_COLOR_FRAME = "rscolor_center_neck_fix_frame";
    public static final String HEAD_POSE_P_R_FRAME = "head_center_neck_pitch_frame";
    public static final String PLATFORM_CAM_FRAME = "platform_center_head_fix_frame";  //+head_pose_roll

    SensorManager mSensorManager;

    private Sensor() {
        mSensorManager = new SensorManager();
    }

    /**
     * Gets an instance of the RobotInfraredManager.
     *
     * @return the RobotInfraredManager instance.
     */
    public static synchronized Sensor getInstance() {
        if (mSensor == null) {
            mSensor = new Sensor();
        }
        return mSensor;
    }

    /**
     * Get robot ultrasonic distance info.
     * @return {@link UltrasonicData}
     */
    public UltrasonicData getUltrasonicDistance() {
        return mSensorManager.getUltrasonicDistance();
    }

    /**
     * Get robot infrared distance info.
     * @return {@link InfraredData}
     */
    public InfraredData getInfraredDistance() {
        return mSensorManager.getInfraredDistance();
    }

    /**
     * Get robot info, include Head (pitch yaw roll...)
     * Base (pitch yaw roll) {@link InfraredData} and {@link UltrasonicData}.
     * use {@link Sensor#getRobotAllSensors()} replace, this method will delete.
     * @return {@link RobotTotalInfo}
     */
    @Deprecated
    public RobotTotalInfo getRobotTotalInfo() {
            return mSensorManager.getRobotTotalInfo();
    }

    /**
     * Get robot Tf (transforms information) data from sourceFrame to targetFrame (based on sourceFrame).
     * @param sourceFrame source {@link Sensor#HEAD_POSE_P_FRAME ...}
     * @param targetFrame target {@link Sensor#HEAD_POSE_P_FRAME ...}
     * @return {@link AlgoTfData}
     */
    public AlgoTfData getTfData(String targetFrame, String sourceFrame, long lookupTimestamp, int timeTrhMs) {
        return mSensorManager.getTfData(targetFrame, sourceFrame, lookupTimestamp, timeTrhMs);
    }

    public AlgoTfData getTfData(AlgoTfRequest req) {
        return mSensorManager.getTfData(req);
    }

    public List<AlgoTfData> getMassiveTfData(List<AlgoTfRequest> requestList){
        return mSensorManager.getMassiveTfData(requestList);
    }

    public boolean setCustomizationTF(AlgoTfData tfData) {
        return mSensorManager.setCustomizationTF(tfData);
    }

    /**
     * Get robot info, include Head (pitch yaw roll...)
     * Base (pitch yaw roll) {@link InfraredData} and {@link UltrasonicData}.
     *
     * @return {@link RobotAllSensors}
     */
    @Override
    public RobotAllSensors getRobotAllSensors() {
        return mSensorManager.getRobotAllSensors();
    }

    /**
     * get Sensor data {@link SensorData}
     * @param type
     * @return
     */
    @Override
    public SensorData[] getSensorData(int type) {
        return mSensorManager.getSensorData(type);
    }

    @Override
    public GxBodySensor getGxBodySensor() {
        return mSensorManager.getGxBodySensor();
    }

    @Override
    public GxBumper getGxBumper() {
        return mSensorManager.getGxBumper();
    }

    @Override
    public GxInfrared getGxInfrared(int type) {
        return mSensorManager.getGxInfrared(type);
    }

    /**
     * Connect to the robot base service. This method must be called before using the {@link Sensor}
     * APIs.
     *
     * @param context  any Android context.
     * @param listener the bind state listener {@link BindStateListener}.
     * @return true if bind service successfully, otherwise false.
     */
    @Override
    public boolean bindService(Context context, BindStateListener listener) {
        return mSensorManager.bindService(context, listener);
    }

    /**
     * Disconnect from the robot {@link Sensor} service.
     */
    @Override
    public void unbindService() {
        mSensorManager.unbindService();
    }

    /**
     * Get the binding state.
     * @return the binding state.
     */
    @Override
    public boolean isBind() {
        return mSensorManager.isBind();
    }

    @Override
    public BindStateListener getBindStateListener() {
        return mSensorManager.getBindStateListener();
    }
}
