package com.segway.robot.sdk.perception.sensor;

import com.segway.robot.algo.tf.AlgoTfData;
import com.segway.robot.algo.tf.AlgoTfRequest;
import com.segway.robot.sdk.perception.sensor.gx.GxBodySensor;
import com.segway.robot.sdk.perception.sensor.gx.GxBumper;
import com.segway.robot.sdk.perception.sensor.gx.GxInfrared;

import java.util.List;

/**
 * Created by sgs on 2017/10/23.
 */

public abstract class ISensor {

    abstract UltrasonicData getUltrasonicDistance();

    abstract InfraredData getInfraredDistance();

    abstract RobotTotalInfo getRobotTotalInfo();

    abstract AlgoTfData getTfData(String tgt, String src, long lookupTimestamp, int timeTrhMs);

    abstract AlgoTfData getTfData(AlgoTfRequest req);

    abstract List<AlgoTfData> getMassiveTfData(List<AlgoTfRequest> requestList);

    abstract boolean setCustomizationTF(AlgoTfData tfData);

    abstract RobotAllSensors getRobotAllSensors();

    abstract SensorData[] getSensorData(int type);
    abstract GxBodySensor getGxBodySensor();
    abstract GxBumper getGxBumper();
    abstract GxInfrared getGxInfrared(int type);

}
