package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;


/**
 * Robot ultrasonic data, include ultrasonic distance and timestamp.
 */
public class UltrasonicData implements StampedData, Parcelable {

    public static final Creator<UltrasonicData> CREATOR = new Creator<UltrasonicData>() {
        @Override
        public UltrasonicData createFromParcel(Parcel in) {
            return new UltrasonicData(in);
        }

        @Override
        public UltrasonicData[] newArray(int size) {
            return new UltrasonicData[size];
        }
    };
    long mTimestamp;
    float mDistance;

    public UltrasonicData(long timestamp, float distance) {
        mTimestamp = timestamp;
        mDistance = distance;
    }

    protected UltrasonicData(Parcel in) {
        mTimestamp = in.readLong();
        mDistance = in.readFloat();
    }

    /**
     * Get the value of the robot ultrasonic distance obstacle. unit is mm.
     * @return ultrasonic distance obstacle
     */
    public float getDistance() {
        return mDistance;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimestamp);
        dest.writeFloat(mDistance);
    }

    @Override
    public long getTimestamp() {
        return mTimestamp;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - mTimestamp;
    }

    @Override
    public String toString() {
        return "UltrasonicData{" +
                "timestamp=" + mTimestamp +
                ", distance=" + mDistance +
                '}';
    }
}
