/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.mobile.sdk.connectivity;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.segway.robot.mobile.sdk.connectivity.BufferMessage;
import com.segway.robot.mobile.sdk.connectivity.MobileException;
import com.segway.robot.mobile.sdk.connectivity.MobileKeepAliveImpl;
import com.segway.robot.mobile.sdk.connectivity.MobileMessageHandler;
import com.segway.robot.mobile.sdk.connectivity.SessionStateCallback;
import com.segway.robot.mobile.sdk.connectivity.StringMessage;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.baseconnectivity.ByteMessage;
import com.segway.robot.sdk.baseconnectivity.MessageConnection;
import com.segway.robot.sdk.baseconnectivity.MessageRouter;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.keepalive.KeepAliveFilter;
import org.apache.mina.filter.keepalive.KeepAliveMessageFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.json.JSONException;
import org.json.JSONObject;

public class MobileMessageSocket {
    private static final String TAG = "MobileMessageSocket";
    private MobileMessageHandler mMobileMessageHandler = null;
    private NioSocketConnector mConnector = null;
    private static MobileMessageSocket mMobileMessageSocket = null;
    private ConnectFuture mConnectFuture = null;
    private IoSession mIoSession = null;
    private String mPackageName = null;
    private String mIp = null;
    private HandlerThread connectThread = null;
    private Handler mHandler = null;
    private ConnectRunnable mConnectRunnable = null;
    private boolean isSessionOpened = false;
    private static Object mLock = new Object();
    private ServiceBinder.BindStateListener mBindStateListener = null;
    private boolean isRepeatedConnect = false;
    private static final int PORT = 7798;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int RECONNECT_INTERVAL = 10000;
    private SessionStateCallback sessionStateCallback = new SessionStateCallback(){

        @Override
        public void onSessionClosed() {
            Log.d((String)MobileMessageSocket.TAG, (String)"onSessionClosed: ");
            MobileMessageSocket.this.mIoSession = null;
            MobileMessageSocket.this.isSessionOpened = false;
            if (MobileMessageSocket.this.isRepeatedConnect) {
                MobileMessageSocket.this.mBindStateListener.onUnbind("The robot has been connected with the other mobile!");
            } else {
                MobileMessageSocket.this.mBindStateListener.onUnbind("The IO session is closed.");
                if (!MobileMessageSocket.this.mConnector.isDisposed() && MobileMessageSocket.this.mMobileMessageHandler != null && !MobileMessageSocket.this.isConnected()) {
                    MobileMessageSocket.this.connect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionOpened() {
            MobileMessageSocket.this.isSessionOpened = true;
            MobileMessageSocket.this.isRepeatedConnect = false;
            MobileMessageSocket.this.mBindStateListener.onBind();
            MobileMessageSocket.this.mHandler.removeCallbacks((Runnable)MobileMessageSocket.this.mConnectRunnable);
            Object object = mLock;
            synchronized (object) {
                MobileMessageSocket.this.mIoSession = MobileMessageSocket.this.mConnectFuture.getSession();
            }
        }

        @Override
        public void onSessionRepeated(IoSession ioSession) {
            MobileMessageSocket.this.isRepeatedConnect = true;
            ioSession.closeNow();
        }
    };

    public static synchronized MobileMessageSocket getInstance() {
        if (mMobileMessageSocket == null) {
            mMobileMessageSocket = new MobileMessageSocket();
        }
        return mMobileMessageSocket;
    }

    private MobileMessageSocket() {
        Log.d((String)TAG, (String)"MobileMessageSocket: init");
        this.mMobileMessageHandler = new MobileMessageHandler();
        this.connectThread = new HandlerThread("ConnectThread");
        this.connectThread.start();
        this.mHandler = new Handler(this.connectThread.getLooper());
        this.mConnector = new NioSocketConnector();
        this.mConnector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        ObjectSerializationCodecFactory codecFactory = new ObjectSerializationCodecFactory();
        codecFactory.setDecoderMaxObjectSize(0x200000);
        codecFactory.setEncoderMaxObjectSize(0x200000);
        this.mConnector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)codecFactory));
        MobileKeepAliveImpl heartBeatFactory = new MobileKeepAliveImpl();
        KeepAliveFilter heartBeatFilter = new KeepAliveFilter((KeepAliveMessageFactory)heartBeatFactory, IdleStatus.BOTH_IDLE);
        heartBeatFilter.setForwardEvent(true);
        heartBeatFilter.setRequestInterval(15);
        heartBeatFilter.setRequestTimeout(5);
        this.mConnector.getFilterChain().addLast("heart", (IoFilter)heartBeatFilter);
        this.mConnector.setConnectTimeoutMillis(30000L);
        this.mConnector.getSessionConfig().setWriteTimeout(5);
        this.mConnector.setHandler((IoHandler)this.mMobileMessageHandler);
        this.setSessionStateChange(this.sessionStateCallback);
    }

    public synchronized void disconnect() {
        if (this.mConnectRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mConnectRunnable);
            Log.d((String)TAG, (String)"disconnect: remove connect runnable");
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = mLock;
                synchronized (object) {
                    if (!MobileMessageSocket.this.mConnector.isDisposed() && MobileMessageSocket.this.mIoSession != null) {
                        MobileMessageSocket.this.mIoSession.getCloseFuture().awaitUninterruptibly(100L);
                        MobileMessageSocket.this.mIoSession = null;
                        MobileMessageSocket.this.isSessionOpened = false;
                        MobileMessageSocket.this.mConnector.dispose();
                        Log.d((String)MobileMessageSocket.TAG, (String)"dispose thread run: over");
                    }
                }
            }
        }).start();
        this.mMobileMessageHandler = null;
        this.mHandler = null;
        this.mConnectRunnable = null;
        this.connectThread.quit();
        mMobileMessageSocket = null;
        Log.d((String)TAG, (String)"disconnect: MobileMessageSocket set to null!");
    }

    public synchronized void initSocketClient(String packageName, String ip, ServiceBinder.BindStateListener listener) {
        if (this.mConnector == null) {
            throw new NullPointerException("Connector is null pointer!");
        }
        this.mIp = ip;
        this.mPackageName = packageName;
        this.mBindStateListener = listener;
    }

    public synchronized void connect() {
        if (this.isSessionOpened || this.mIoSession != null) {
            return;
        }
        if (this.mConnectRunnable == null) {
            this.mConnectRunnable = new ConnectRunnable(this.mIp);
        }
        this.mHandler.post((Runnable)this.mConnectRunnable);
    }

    public boolean isConnected() {
        return this.mMobileMessageHandler != null && this.mMobileMessageHandler.isConnected();
    }

    public void sendMessage(String to, StringMessage body) throws MobileException {
        JSONObject jsonMessage = new JSONObject();
        try {
            jsonMessage.put("msg_id", body.getId());
            jsonMessage.put("timestamp", MessageUtil.getTimestamp());
            jsonMessage.put("from", (Object)this.mPackageName);
            jsonMessage.put("to", (Object)to);
            jsonMessage.put("msg_body", (Object)body.getContent());
        }
        catch (JSONException e) {
            throw MobileException.getJsonException(e.getMessage(), e);
        }
        if (this.mMobileMessageHandler != null && this.mConnector != null) {
            this.mMobileMessageHandler.sendMessage(jsonMessage.toString());
        }
    }

    public void sendMessage(String to, BufferMessage body) throws MobileException {
        ByteMessage byteMessage = new ByteMessage(body.getId(), MessageUtil.getTimestamp(), this.mPackageName, to, body.getContent());
        byte[] bufferMessage = byteMessage.packByteMessage(byteMessage);
        if (this.mMobileMessageHandler != null && this.mConnector != null) {
            this.mMobileMessageHandler.sendMessage(bufferMessage);
        }
    }

    private void setSessionStateChange(SessionStateCallback callback) {
        this.mMobileMessageHandler.setSessionChangedCallback(callback);
    }

    public void setConnectionListener(MessageRouter.MessageConnectionListener listener) {
        this.mMobileMessageHandler.setMessageConnectionListener(listener);
    }

    public void setMetaData(String packageName, Set set) {
        this.mMobileMessageHandler.setMetaData(packageName, set);
    }

    public void setListenersReady(String from, String to, MessageConnection.ConnectionStateListener connectionStateListener, MessageConnection.MessageListener messageListener) {
        this.mMobileMessageHandler.setListenersReady(from, to, connectionStateListener, messageListener);
    }

    private class ConnectRunnable
    implements Runnable {
        private String mIp = null;

        public ConnectRunnable(String ip) {
            this.mIp = ip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = mLock;
            synchronized (object) {
                if (MobileMessageSocket.this.isSessionOpened || MobileMessageSocket.this.mIoSession != null) {
                    return;
                }
                if (!MobileMessageSocket.this.mConnector.isDisposed()) {
                    MobileMessageSocket.this.mConnectFuture = MobileMessageSocket.this.mConnector.connect((SocketAddress)new InetSocketAddress(this.mIp, 7798));
                    MobileMessageSocket.this.mConnectFuture.awaitUninterruptibly();
                    MobileMessageSocket.this.mHandler.postDelayed((Runnable)this, 10000L);
                }
                Log.d((String)MobileMessageSocket.TAG, (String)"run: ConnectRunnable");
            }
        }
    }
}

