package com.segway.robot.mobile.sdk.connectivity;

import com.segway.robot.sdk.baseconnectivity.Message;

/**
 * BufferMessage to be sent when {@link MobileMessageConnection} is created.
 */
public class BufferMessage extends Message<byte[]> {

    /**
     * Create an empty {@code BufferMessage}.
     */
    public BufferMessage() {
        super();
    }

    protected BufferMessage(long timestamp, byte[] content, int id) {
        super(timestamp, content, id);
    }

    /**
     * Create an empty {@code BufferMessage} with the message content initialized.
     *
     * @param content the content of BufferMessage to be sent.
     */
    public BufferMessage(byte[] content) {
        super(content);
    }

    /**
     * Get the message ID.
     *
     * @return the ID of BufferMessage to be sent.
     */
    @Override
    public int getId() {
        return super.getId();
    }

    /**
     * Get the timestamp when the BufferMessage is sent.
     *
     * @return the timestamp of BufferMessage to be sent.
     */
    @Override
    public long getTimestampSent() {
        return super.getTimestampSent();
    }

    /**
     * Set the message content.
     *
     * @param message the content of the message to be set for BufferMessage.
     */
    @Override
    public void setContent(byte[] message) {
        super.setContent(message);
    }

    /**
     * Get the message content.
     *
     * @return the content of BufferMessage.
     */
    @Override
    public byte[] getContent() {
        return super.getContent();
    }
}
