/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.mobile.sdk.connectivity;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.segway.robot.mobile.sdk.connectivity.BufferMessage;
import com.segway.robot.mobile.sdk.connectivity.MobileException;
import com.segway.robot.mobile.sdk.connectivity.MobileMessageSocket;
import com.segway.robot.mobile.sdk.connectivity.StringMessage;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.baseconnectivity.MessageConnection;
import com.segway.robot.sdk.baseconnectivity.MessageRouter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MobileMessageRouter
extends MessageRouter {
    private static final String TAG = "MobileMessageRouter";
    private static MobileMessageRouter mMobileMessageRouter = null;
    private Context mContext = null;
    private MobileMessageSocket mMobileMessageSocket = null;
    private MessageRouter.MessageConnectionListener mMessageConnectionListener = null;
    private String mIp = "";

    private MobileMessageRouter() {
    }

    public static synchronized MobileMessageRouter getInstance() {
        if (mMobileMessageRouter == null) {
            mMobileMessageRouter = new MobileMessageRouter();
        }
        return mMobileMessageRouter;
    }

    public synchronized void register(MessageRouter.MessageConnectionListener messageConnectionListener) throws Exception {
        if (messageConnectionListener == null) {
            throw new IllegalArgumentException("MessageConnectionListener can't be null!");
        }
        if (this.mMobileMessageSocket == null) {
            throw new IllegalStateException("MobileMessageRouter isn't bind");
        }
        this.mMessageConnectionListener = messageConnectionListener;
        this.mMobileMessageSocket.setConnectionListener(this.mMessageConnectionListener);
    }

    public synchronized void setConnectionIp(String ip) {
        if (TextUtils.isEmpty((CharSequence)ip)) {
            throw new IllegalArgumentException("IP can't be null!");
        }
        if (!this.isIpLegal(ip)) {
            throw new IllegalArgumentException("IP " + ip + " is illegal!");
        }
        this.mIp = ip;
    }

    public synchronized void unregister() {
        if (this.mMobileMessageSocket == null) {
            throw new IllegalStateException("MobileMessageRouter isn't bind");
        }
        this.mMobileMessageSocket.removeConnectionListener();
        this.mMessageConnectionListener = null;
    }

    public boolean isRegistered() {
        return this.mMessageConnectionListener != null;
    }

    public boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("Context can't be null!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("BindStateListener can't be null!");
        }
        if (this.mMobileMessageSocket == null) {
            this.mMobileMessageSocket = new MobileMessageSocket();
        }
        this.mContext = context.getApplicationContext();
        try {
            this.setMetaData(this.mContext.getPackageName(), this.getMetaData(this.mContext));
        }
        catch (MobileException e) {
            Log.e((String)TAG, (String)"Get MobileException: ", (Throwable)e);
        }
        this.mMobileMessageSocket.initSocketClient(this.mContext.getPackageName(), this.mIp, listener);
        return this.mMobileMessageSocket.connect();
    }

    public void unbindService() {
        if (this.mMobileMessageSocket == null) {
            throw new IllegalStateException("MobileMessageRouter isn't bind");
        }
        if (this.mMessageConnectionListener != null) {
            this.mMobileMessageSocket.removeConnectionListener();
            this.mMessageConnectionListener = null;
        }
        this.mMobileMessageSocket.disconnect();
        this.mMobileMessageSocket = null;
    }

    protected void sendBufferMessage(String to, BufferMessage message) throws MobileException {
        if (this.mMobileMessageSocket == null) {
            throw new IllegalStateException("MobileMessageRouter isn't bind");
        }
        this.mMobileMessageSocket.sendMessage(to, message);
    }

    protected void sendStringMessage(String to, StringMessage message) throws MobileException {
        if (this.mMobileMessageSocket == null) {
            throw new IllegalStateException("MobileMessageRouter isn't bind");
        }
        this.mMobileMessageSocket.sendMessage(to, message);
    }

    protected void setListenersReady(String to, MessageConnection.ConnectionStateListener connectionStateListener, MessageConnection.MessageListener messageListener) throws MobileException {
        if (this.mMobileMessageSocket == null) {
            throw new IllegalStateException("MobileMessageRouter isn't bind");
        }
        this.mMobileMessageSocket.setListenersReady(this.mContext.getPackageName(), to, connectionStateListener, messageListener);
    }

    protected synchronized Set getMetaData(Context context) throws MobileException {
        ApplicationInfo applicationInfo;
        if (context == null) {
            throw new IllegalArgumentException("The context can't be null!");
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            throw new IllegalArgumentException("Cannot get PackageManager.");
        }
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw MobileException.getPackageNameNotFound(e.getMessage(), e);
        }
        if (applicationInfo == null) {
            throw new IllegalArgumentException("Cannot get ApplicationInfo.");
        }
        Bundle data = applicationInfo.metaData;
        if (data == null) {
            throw new IllegalArgumentException("The application metadata is illegal!");
        }
        HashSet<String> metaData = new HashSet<String>();
        for (String key : data.keySet()) {
            String value = data.getString(key);
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            metaData.add(value);
        }
        return metaData;
    }

    private void setMetaData(String packageName, Set set) {
        if (this.mMobileMessageSocket == null) {
            throw new IllegalStateException("MobileMessageRouter isn't bind!");
        }
        if (set == null) {
            throw new IllegalArgumentException("Get metadata failed!");
        }
        this.mMobileMessageSocket.setMetaData(packageName, set);
    }

    private boolean isIpLegal(String ip) {
        String ipCheck = "(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])";
        Pattern pattern = Pattern.compile(ipCheck);
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }
}

