/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.mobile.sdk.connectivity;

import com.segway.robot.mobile.sdk.connectivity.BufferMessage;
import com.segway.robot.mobile.sdk.connectivity.MobileException;
import com.segway.robot.mobile.sdk.connectivity.MobileMessageConnection;
import com.segway.robot.mobile.sdk.connectivity.SessionStateCallback;
import com.segway.robot.mobile.sdk.connectivity.StringMessage;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.baseconnectivity.ByteMessage;
import com.segway.robot.sdk.baseconnectivity.ConnectionInfo;
import com.segway.robot.sdk.baseconnectivity.Message;
import com.segway.robot.sdk.baseconnectivity.MessageConnection;
import com.segway.robot.sdk.baseconnectivity.MessageRouter;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.json.JSONException;
import org.json.JSONObject;

public class MobileMessageHandler
extends IoHandlerAdapter {
    private static final String TAG = "MobileMessageHandler";
    private static final String MOBILE_HEARTBEAT = "mobile";
    private MessageRouter.MessageConnectionListener mMessageConnectionListener = null;
    private Map<String, String> mRobotMetaDataMap = new ConcurrentHashMap<String, String>();
    private IoSession mIoSession = null;
    private SessionStateCallback mSessionStateCallback = null;
    private ConnectionInfo mConnectionInfo = new ConnectionInfo();
    private final Map<String, MobileMessageConnection> mMessageConnectionMap = new ConcurrentHashMap<String, MobileMessageConnection>();
    private final List<ConnectionReadyInfo> mConnectionsReadyInfo = new ArrayList<ConnectionReadyInfo>();

    public void messageReceived(IoSession session, Object message) throws Exception {
        super.messageReceived(session, message);
        if (message instanceof byte[]) {
            this.receiveByteMessage(message);
        } else {
            JSONObject jsonObject = new JSONObject(message.toString());
            if (jsonObject.has("ACTION.ADD_NEW")) {
                this.receiveAddNew(jsonObject);
            } else if (jsonObject.has("ACTION.REMOVE_HOST")) {
                this.receiveRemoveHost(jsonObject);
            } else if (jsonObject.has("ACTION.UPDATE_ROBOT_LIST")) {
                this.receiveUpdateList(jsonObject);
            } else if (jsonObject.has("ACTION.REMOVE_DEAD")) {
                this.receiveRemoveDeadHost(jsonObject);
            } else if (jsonObject.has("ACTION.MESSAGE_LISTENER_READY")) {
                this.receiveListenerReady(jsonObject);
            } else if (jsonObject.has("ACTION.REPEATED_CONNECTION")) {
                Logger.w((String)TAG, (String)"ACTION.REPEATED_CONNECTION >>>>> robot has been connected");
                this.mSessionStateCallback.onSessionRepeated(session);
            } else {
                this.receiveStringMessage(jsonObject);
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        super.messageSent(session, message);
        if (message instanceof byte[]) {
            this.onByteMessageSent(message);
        } else {
            this.onStringMessageSent(message);
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        super.sessionOpened(session);
        Logger.d((String)TAG, (String)("Mobile sessionOpened:" + session));
        this.mIoSession = session;
        this.mSessionStateCallback.onSessionOpened(session);
        this.mConnectionInfo.setIoSession(session);
        session.write((Object)this.setSessionOpenMessage());
    }

    public void sessionClosed(IoSession session) throws Exception {
        Logger.w((String)TAG, (String)("Mobile sessionClosed: " + session));
        super.sessionClosed(session);
        this.doIoSessionClosed(null);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        super.sessionIdle(session, status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        super.exceptionCaught(session, cause);
        Logger.e((String)TAG, (String)"Mobile exceptionCaught: ", (Throwable)cause);
        if (cause instanceof IOException) {
            this.doIoSessionClosed(cause);
        }
        throw MobileException.getIoSessionException("IoSession exception!", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveByteMessage(Object message) throws Exception {
        ByteMessage byteMessage = new ByteMessage();
        byteMessage.unpackMessage((byte[])message, byteMessage);
        String from = byteMessage.mFrom;
        String to = byteMessage.mTo;
        int id = byteMessage.mId;
        long timestamp = byteMessage.mTimestamp;
        byte[] messageByte = byteMessage.mMessage;
        Logger.v((String)TAG, (String)("messageReceived >>> BufferMessage >>> id=" + id + ";timestamp=" + timestamp + ";from=" + from + ";to=" + to + ";m-length=" + messageByte.length));
        List<ConnectionReadyInfo> list = this.mConnectionsReadyInfo;
        synchronized (list) {
            for (ConnectionReadyInfo info : this.mConnectionsReadyInfo) {
                if (!info.mPackage.equals(to) || !info.mPackageTo.equals(from) || info.mMessageListener == null) continue;
                BufferMessage bufferMessage = new BufferMessage(timestamp, messageByte, id);
                info.mMessageListener.onMessageReceived((Message)bufferMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveStringMessage(JSONObject jsonObject) throws Exception {
        String from = jsonObject.getString("from");
        String to = jsonObject.getString("to");
        String body = jsonObject.getString("msg_body");
        long time = jsonObject.getLong("timestamp");
        int id = jsonObject.getInt("msg_id");
        Logger.v((String)TAG, (String)("messageReceived >>> StringMessage >>> id=" + id + ";timestamp=" + time + ";from=" + from + ";to=" + to));
        List<ConnectionReadyInfo> list = this.mConnectionsReadyInfo;
        synchronized (list) {
            for (ConnectionReadyInfo info : this.mConnectionsReadyInfo) {
                if (!from.equals(info.mPackageTo) || !to.equals(info.mPackage) || info.mMessageListener == null) continue;
                StringMessage stringMessage = new StringMessage(time, body, id);
                info.mMessageListener.onMessageReceived((Message)stringMessage);
            }
        }
    }

    private void receiveAddNew(JSONObject jsonObject) throws Exception {
        String data = jsonObject.getString("ACTION.ADD_NEW");
        String from = jsonObject.getString("from");
        Logger.d((String)TAG, (String)("ACTION.ADD_NEW >>>>> " + data));
        this.mRobotMetaDataMap.put(from, data);
        if (this.mConnectionInfo.getMetadata().contains(from)) {
            MobileMessageConnection messageConnection = new MobileMessageConnection(from);
            this.mMessageConnectionMap.put(from, messageConnection);
            if (this.mMessageConnectionListener != null) {
                this.mMessageConnectionListener.onConnectionCreated((MessageConnection)messageConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveRemoveHost(JSONObject jsonObject) throws Exception {
        String from = jsonObject.getString("from");
        Logger.d((String)TAG, (String)("ACTION.REMOVE_HOST >>>>> " + from));
        this.mRobotMetaDataMap.remove(from);
        MobileMessageConnection connection = this.mMessageConnectionMap.get(from);
        if (connection != null) {
            MessageConnection.ConnectionStateListener listener = connection.getConnectionStateListener();
            if (listener != null) {
                listener.onClosed("The robot application is disconnected!");
            }
            connection.removeConnectionStateListener();
            connection.removeMessageListener();
            this.mMessageConnectionMap.remove(from);
        }
        List<ConnectionReadyInfo> list = this.mConnectionsReadyInfo;
        synchronized (list) {
            Iterator<ConnectionReadyInfo> iterator = this.mConnectionsReadyInfo.iterator();
            while (iterator.hasNext()) {
                ConnectionReadyInfo info = iterator.next();
                if (!from.equals(info.mPackageTo)) continue;
                info.clear();
                iterator.remove();
            }
        }
    }

    private void receiveUpdateList(JSONObject jsonObject) throws Exception {
        JSONObject object = new JSONObject(jsonObject.getString("ACTION.UPDATE_ROBOT_LIST"));
        this.mRobotMetaDataMap = MessageUtil.packJsonToMap((JSONObject)object);
        Logger.d((String)TAG, (String)("ACTION.UPDATE_ROBOT_LIST >>>>> " + this.mRobotMetaDataMap.toString()));
        for (String robot : this.mConnectionInfo.getMetadata()) {
            if (!this.mRobotMetaDataMap.containsKey(robot) || !this.mRobotMetaDataMap.get(robot).contains(this.mConnectionInfo.getPackageName())) continue;
            MobileMessageConnection messageConnection = new MobileMessageConnection(robot);
            this.mMessageConnectionMap.put(robot, messageConnection);
            if (this.mMessageConnectionListener == null) continue;
            this.mMessageConnectionListener.onConnectionCreated((MessageConnection)messageConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveRemoveDeadHost(JSONObject jsonObject) throws Exception {
        MobileMessageConnection connection;
        String name = jsonObject.getString("ACTION.REMOVE_DEAD");
        String hostMeta = this.mRobotMetaDataMap.get(name);
        Logger.d((String)TAG, (String)("ACTION.REMOVE_DEAD >>>>> " + name + ";" + hostMeta));
        if (hostMeta != null && hostMeta.contains(this.mConnectionInfo.getPackageName()) && this.mConnectionInfo.getMetadata().contains(name) && (connection = this.mMessageConnectionMap.get(name)) != null) {
            MessageConnection.ConnectionStateListener listener = connection.getConnectionStateListener();
            if (listener != null) {
                listener.onClosed("The robot application is disconnected!");
            }
            connection.removeMessageListener();
            connection.removeConnectionStateListener();
            this.mMessageConnectionMap.remove(name);
        }
        List<ConnectionReadyInfo> list = this.mConnectionsReadyInfo;
        synchronized (list) {
            Iterator<ConnectionReadyInfo> iterator = this.mConnectionsReadyInfo.iterator();
            while (iterator.hasNext()) {
                ConnectionReadyInfo info = iterator.next();
                if (!name.equals(info.mPackageTo)) continue;
                iterator.remove();
            }
        }
        this.mRobotMetaDataMap.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveListenerReady(JSONObject jsonObject) throws Exception {
        String from = jsonObject.getString("from");
        String to = jsonObject.getString("ACTION.MESSAGE_LISTENER_READY");
        Logger.d((String)TAG, (String)("ACTION.MESSAGE_LISTENER_READY >>>>> from= " + from + "; to=" + to));
        List<ConnectionReadyInfo> list = this.mConnectionsReadyInfo;
        synchronized (list) {
            for (ConnectionReadyInfo info : this.mConnectionsReadyInfo) {
                if (!info.mPackage.equals(to) || !info.mPackageTo.equals(from) || info.mConnectionStateListener == null) continue;
                info.mConnectionStateListener.onOpened();
                Logger.d((String)TAG, (String)("on opened = " + from));
            }
        }
    }

    private void onByteMessageSent(Object message) throws Exception {
        ByteMessage byteMessage = new ByteMessage();
        byteMessage.unpackMessage((byte[])message, byteMessage);
        String from = byteMessage.mFrom;
        String to = byteMessage.mTo;
        int id = byteMessage.mId;
        long timestamp = byteMessage.mTimestamp;
        byte[] messageByte = byteMessage.mMessage;
        Logger.v((String)TAG, (String)("messageSent >>> BufferMessage >>> id=" + id + ";timestamp=" + timestamp + ";from=" + from + ";to=" + to));
        for (MobileMessageConnection connection : this.mMessageConnectionMap.values()) {
            if (!to.equals(connection.getName()) || connection.getMessageListener() == null) continue;
            BufferMessage bufferMessage = new BufferMessage(timestamp, messageByte, id);
            connection.getMessageListener().onMessageSent((Message)bufferMessage);
        }
    }

    private void onStringMessageSent(Object message) throws Exception {
        JSONObject json = new JSONObject(message.toString());
        if (this.checkMessageSent(json)) {
            String to = json.getString("to");
            String from = json.getString("from");
            String body = json.getString("msg_body");
            long timestamp = json.getLong("timestamp");
            int id = json.getInt("msg_id");
            Logger.v((String)TAG, (String)("messageSent >>> StringMessage >>> id=" + id + ";timestamp=" + timestamp + ";from=" + from + ";to=" + to));
            for (MobileMessageConnection connection : this.mMessageConnectionMap.values()) {
                if (!to.equals(connection.getName()) || connection.getMessageListener() == null) continue;
                StringMessage stringMessage = new StringMessage(timestamp, body, id);
                connection.getMessageListener().onMessageSent((Message)stringMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIoSessionClosed(Throwable cause) {
        this.mIoSession = null;
        this.mSessionStateCallback.onSessionClosed();
        for (MobileMessageConnection connection : this.mMessageConnectionMap.values()) {
            MessageConnection.ConnectionStateListener listener = connection.getConnectionStateListener();
            if (listener == null) continue;
            if (cause != null) {
                listener.onClosed(cause.getMessage());
                continue;
            }
            listener.onClosed("The IO session is closed.");
        }
        this.mMessageConnectionMap.clear();
        List<ConnectionReadyInfo> list = this.mConnectionsReadyInfo;
        synchronized (list) {
            this.mConnectionsReadyInfo.clear();
        }
    }

    protected boolean isConnected() {
        return this.mIoSession != null;
    }

    protected void sendMessage(Object message, String to) throws MobileException {
        if (this.mIoSession == null) {
            throw MobileException.getNotConnectedException("Can't send messages to the disconnected device");
        }
        if (!this.mMessageConnectionMap.containsKey(to)) {
            throw MobileException.getMessageConnectionClosedException("Can't send messages to closed MessageConnection: " + to);
        }
        this.mIoSession.write(message);
    }

    protected void setSessionChangedCallback(SessionStateCallback callback) {
        this.mSessionStateCallback = callback;
    }

    protected void setMessageConnectionListener(MessageRouter.MessageConnectionListener listener) {
        this.mMessageConnectionListener = listener;
    }

    protected void removeMessageConnectionListener() {
        this.mMessageConnectionListener = null;
    }

    protected void setMetaData(String packageName, Set set) {
        Logger.d((String)TAG, (String)("setMetaData: name=" + packageName + "; set =" + set.toString()));
        this.mConnectionInfo.setPackageName(packageName);
        this.mConnectionInfo.setMetadata(set);
    }

    private String setSessionOpenMessage() {
        JSONObject json = new JSONObject();
        try {
            json.put("from", (Object)this.mConnectionInfo.getPackageName());
            json.put("ACTION.SESSION_OPEN", (Object)MessageUtil.packSetToString((Set)this.mConnectionInfo.getMetadata()));
        }
        catch (JSONException e) {
            Logger.e((String)TAG, (String)"JSONException: ", (Throwable)e);
        }
        return json.toString();
    }

    protected void setListenersReady(String from, String to, MessageConnection.ConnectionStateListener connectionStateListener, MessageConnection.MessageListener messageListener) {
        ConnectionReadyInfo info = new ConnectionReadyInfo(from, to, connectionStateListener, messageListener);
        this.mConnectionsReadyInfo.add(info);
        this.sendListenerReadyInfo(from, to);
    }

    private void sendListenerReadyInfo(String packageName, String to) {
        if (this.isConnected()) {
            JSONObject object = new JSONObject();
            try {
                object.put("timestamp", MessageUtil.getTimestamp());
                object.put("from", (Object)packageName);
                object.put("ACTION.MESSAGE_LISTENER_READY", (Object)to);
            }
            catch (JSONException e) {
                Logger.e((String)TAG, (String)"Message is not json", (Throwable)e);
            }
            this.mConnectionInfo.getIoSession().write((Object)object.toString());
        }
    }

    protected void sendUnbindInfo(String packageName) {
        if (this.isConnected()) {
            JSONObject object = new JSONObject();
            try {
                object.put("timestamp", MessageUtil.getTimestamp());
                object.put("ACTION.MOBILE_UNBIND", (Object)packageName);
            }
            catch (JSONException e) {
                Logger.e((String)TAG, (String)"Message is not json", (Throwable)e);
            }
            this.mConnectionInfo.getIoSession().write((Object)object.toString());
        }
    }

    private boolean checkMessageSent(JSONObject json) {
        return !json.has(MOBILE_HEARTBEAT) && !json.has("ACTION.ADD_NEW") && !json.has("ACTION.UPDATE_ROBOT_LIST") && !json.has("ACTION.REMOVE_HOST") && !json.has("ACTION.REMOVE_DEAD") && !json.has("ACTION.MESSAGE_LISTENER_READY") && !json.has("ACTION.SESSION_OPEN") && !json.has("ACTION.MOBILE_UNBIND");
    }

    protected final class ConnectionReadyInfo {
        protected String mPackage;
        protected String mPackageTo;
        protected MessageConnection.MessageListener mMessageListener = null;
        protected MessageConnection.ConnectionStateListener mConnectionStateListener = null;

        private ConnectionReadyInfo(String packageName, String to, MessageConnection.ConnectionStateListener listener, MessageConnection.MessageListener iMessageListener) {
            this.mPackage = packageName;
            this.mPackageTo = to;
            this.mConnectionStateListener = listener;
            this.mMessageListener = iMessageListener;
        }

        void clear() {
            this.mMessageListener = null;
            this.mConnectionStateListener = null;
        }
    }
}

