/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.mobile.sdk.connectivity;

import com.segway.robot.mobile.sdk.connectivity.BufferMessage;
import com.segway.robot.mobile.sdk.connectivity.MobileException;
import com.segway.robot.mobile.sdk.connectivity.MobileMessageRouter;
import com.segway.robot.mobile.sdk.connectivity.StringMessage;
import com.segway.robot.sdk.baseconnectivity.Message;
import com.segway.robot.sdk.baseconnectivity.MessageConnection;

public class MobileMessageConnection
extends MessageConnection {
    private static final String TAG = "MobileMessageConnection";
    private String mName = null;
    private MessageConnection.MessageListener mMessageListener = null;
    private MessageConnection.ConnectionStateListener mConnectionStateListener = null;
    private MobileMessageRouter mMobileMessageRouter = null;

    protected MobileMessageConnection(String name) {
        this.mName = name;
        this.mMobileMessageRouter = MobileMessageRouter.getInstance();
    }

    public String getName() {
        return this.mName;
    }

    public void setListeners(MessageConnection.ConnectionStateListener connectionStateListener, MessageConnection.MessageListener messageListener) throws MobileException {
        if (connectionStateListener == null) {
            throw new IllegalArgumentException("connectionStateListener can't be null!");
        }
        if (messageListener == null) {
            throw new IllegalArgumentException("MessageListener can't be null!");
        }
        this.mConnectionStateListener = connectionStateListener;
        this.mMessageListener = messageListener;
        this.mMobileMessageRouter.setListenersReady(this.mName, this.mConnectionStateListener, this.mMessageListener);
    }

    public MessageConnection.MessageListener getMessageListener() {
        return this.mMessageListener;
    }

    public MessageConnection.ConnectionStateListener getConnectionStateListener() {
        return this.mConnectionStateListener;
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
    }

    public void sendMessage(Message message) throws MobileException {
        if (message == null) {
            throw new IllegalArgumentException("The message can't be null!");
        }
        if (message.getContent() == null) {
            throw new IllegalArgumentException("The message content can't be null!");
        }
        if (message.getContent() instanceof byte[]) {
            this.sendBufferMessage((BufferMessage)message);
        } else {
            this.sendStringMessage((StringMessage)message);
        }
    }

    private void sendStringMessage(StringMessage message) throws MobileException {
        if (message.getContent().length() > 460800) {
            throw MobileException.getMessageTooLongException("The message is too long!");
        }
        this.mMobileMessageRouter.sendStringMessage(this.mName, message);
    }

    private void sendBufferMessage(BufferMessage message) throws MobileException {
        if (message.getContent().length > 1024000) {
            throw MobileException.getMessageTooLongException("The message is too long!");
        }
        this.mMobileMessageRouter.sendBufferMessage(this.mName, message);
    }
}

