/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.mobile.sdk.connectivity;

import com.segway.robot.mobile.sdk.connectivity.BufferMessage;
import com.segway.robot.mobile.sdk.connectivity.ConnectionReadyInfo;
import com.segway.robot.mobile.sdk.connectivity.MobileException;
import com.segway.robot.mobile.sdk.connectivity.MobileMessageConnection;
import com.segway.robot.mobile.sdk.connectivity.SessionStateCallback;
import com.segway.robot.mobile.sdk.connectivity.StringMessage;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.baseconnectivity.ByteMessage;
import com.segway.robot.sdk.baseconnectivity.ConnectionInfo;
import com.segway.robot.sdk.baseconnectivity.Message;
import com.segway.robot.sdk.baseconnectivity.MessageConnection;
import com.segway.robot.sdk.baseconnectivity.MessageRouter;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.json.JSONException;
import org.json.JSONObject;

public class MobileMessageHandler
extends IoHandlerAdapter {
    private static final String TAG = "MobileMessageHandler";
    private static final String MOBILE_HEARTBEAT = "mobile";
    private boolean isSessionEnable = false;
    private MessageRouter.MessageConnectionListener mMessageConnectionListener = null;
    private Map<String, String> mRobotMetaDataMap = new HashMap<String, String>();
    private IoSession mIoSession = null;
    private SessionStateCallback mSessionStateCallback = null;
    private ConnectionInfo mConnectionInfo = new ConnectionInfo();
    private Map<String, MobileMessageConnection> mMessageConnectionMap = new HashMap<String, MobileMessageConnection>();
    private List<ConnectionReadyInfo> mConnectionsReadyInfo = new ArrayList<ConnectionReadyInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object message) throws Exception {
        block32: {
            JSONObject jsonObject;
            block33: {
                block31: {
                    super.messageReceived(session, message);
                    Logger.d((String)TAG, (String)("Mobile messageReceived: " + message.toString()));
                    if (!(message instanceof byte[])) break block31;
                    ByteMessage byteMessage = new ByteMessage();
                    byteMessage.unpackMessage((byte[])message, byteMessage);
                    String from = byteMessage.mFrom;
                    String to = byteMessage.mTo;
                    int id = byteMessage.mId;
                    long timestamp = byteMessage.mTimestamp;
                    byte[] messageByte = byteMessage.mMessage;
                    Logger.d((String)TAG, (String)("id=" + id + ";timestamp=" + timestamp + ";from=" + from + ";to=" + to + ";m-length=" + messageByte.length));
                    for (ConnectionReadyInfo info : this.mConnectionsReadyInfo) {
                        MessageConnection.MessageListener listener;
                        if (!info.getPackage().equals(to) || !info.getPackageTo().equals(from) || (listener = info.getMessageListener()) == null) continue;
                        BufferMessage bufferMessage = new BufferMessage(timestamp, messageByte, id);
                        listener.onMessageReceived((Message)bufferMessage);
                    }
                    break block32;
                }
                jsonObject = new JSONObject(message.toString());
                if (!jsonObject.has("ACTION.ADD_NEW")) break block33;
                String data = jsonObject.getString("ACTION.ADD_NEW");
                String from = jsonObject.getString("from");
                Logger.d((String)TAG, (String)("ACTION.ADD_NEW=" + data));
                this.mRobotMetaDataMap.put(from, data);
                if (!this.mConnectionInfo.getMetadata().contains(from)) break block32;
                MobileMessageConnection messageConnection = new MobileMessageConnection(from);
                this.mMessageConnectionMap.put(from, messageConnection);
                if (this.mMessageConnectionListener != null) {
                    this.mMessageConnectionListener.onConnectionCreated((MessageConnection)messageConnection);
                }
                break block32;
            }
            if (jsonObject.has("ACTION.REMOVE_HOST")) {
                String from = jsonObject.getString("from");
                Logger.d((String)TAG, (String)("ACTION.REMOVE_HOST=" + from));
                this.mRobotMetaDataMap.remove(from);
                MessageConnection.ConnectionStateListener listener = this.mMessageConnectionMap.get(from).getConnectionStateListener();
                if (listener != null) {
                    listener.onClosed("The robot application is disconnected!");
                }
                this.mMessageConnectionMap.remove(from);
                List<ConnectionReadyInfo> messageConnection = this.mConnectionsReadyInfo;
                synchronized (messageConnection) {
                    Iterator<ConnectionReadyInfo> iterator = this.mConnectionsReadyInfo.iterator();
                    while (iterator.hasNext()) {
                        ConnectionReadyInfo info = iterator.next();
                        if (!from.equals(info.getPackageTo())) continue;
                        iterator.remove();
                    }
                }
            }
            if (jsonObject.has("ACTION.UPDATE_ROBOT_LIST")) {
                JSONObject object = new JSONObject(jsonObject.getString("ACTION.UPDATE_ROBOT_LIST"));
                this.mRobotMetaDataMap = MessageUtil.packJsonToMap((JSONObject)object);
                Logger.d((String)TAG, (String)("ACTION.UPDATE_ROBOT_LIST=" + this.mRobotMetaDataMap.toString()));
                for (String robot : this.mConnectionInfo.getMetadata()) {
                    if (!this.mRobotMetaDataMap.containsKey(robot) || !this.mRobotMetaDataMap.get(robot).contains(this.mConnectionInfo.getPackageName()) || this.mMessageConnectionListener == null) continue;
                    MobileMessageConnection messageConnection = new MobileMessageConnection(robot);
                    this.mMessageConnectionMap.put(robot, messageConnection);
                    this.mMessageConnectionListener.onConnectionCreated((MessageConnection)messageConnection);
                }
            } else if (jsonObject.has("ACTION.REMOVE_DEAD")) {
                MessageConnection.ConnectionStateListener listener;
                String name = jsonObject.getString("ACTION.REMOVE_DEAD");
                String hostMeta = this.mRobotMetaDataMap.get(name);
                Logger.d((String)TAG, (String)("remove dead host " + name + ";" + hostMeta));
                if (hostMeta.contains(this.mConnectionInfo.getPackageName()) && this.mConnectionInfo.getMetadata().contains(name)) {
                    listener = this.mMessageConnectionMap.get(name).getConnectionStateListener();
                    if (listener != null) {
                        listener.onClosed("The robot application is disconnected!");
                    }
                    this.mMessageConnectionMap.remove(name);
                }
                listener = this.mConnectionsReadyInfo;
                synchronized (listener) {
                    Iterator<ConnectionReadyInfo> iterator = this.mConnectionsReadyInfo.iterator();
                    while (iterator.hasNext()) {
                        ConnectionReadyInfo info = iterator.next();
                        if (!name.equals(info.getPackageTo())) continue;
                        iterator.remove();
                    }
                }
                this.mRobotMetaDataMap.remove(name);
            } else if (jsonObject.has("ACTION.MESSAGE_LISTENER_READY")) {
                String from = jsonObject.getString("from");
                String to = jsonObject.getString("ACTION.MESSAGE_LISTENER_READY");
                Logger.d((String)TAG, (String)("ACTION.MESSAGE_LISTENER_READY: from= " + from + "; to=" + to));
                List<ConnectionReadyInfo> listener = this.mConnectionsReadyInfo;
                synchronized (listener) {
                    for (ConnectionReadyInfo info : this.mConnectionsReadyInfo) {
                        MessageConnection.ConnectionStateListener listener2;
                        if (!info.getPackage().equals(to) || !info.getPackageTo().equals(from) || (listener2 = info.getConnectionStateListener()) == null) continue;
                        listener2.onOpened();
                        Logger.d((String)TAG, (String)("on opened = " + from));
                    }
                }
            } else if (jsonObject.has("ACTION.REPEATED_CONNECTION")) {
                this.mSessionStateCallback.onSessionRepeated(session);
            } else {
                String from = jsonObject.getString("from");
                String to = jsonObject.getString("to");
                String body = jsonObject.getString("msg_body");
                long time = jsonObject.getLong("timestamp");
                int id = jsonObject.getInt("msg_id");
                List<ConnectionReadyInfo> list = this.mConnectionsReadyInfo;
                synchronized (list) {
                    for (ConnectionReadyInfo connection : this.mConnectionsReadyInfo) {
                        MessageConnection.MessageListener listener;
                        if (!from.equals(connection.getPackageTo()) || !to.equals(connection.getPackage()) || (listener = connection.getMessageListener()) == null) continue;
                        StringMessage stringMessage = new StringMessage(time, body, id);
                        listener.onMessageReceived((Message)stringMessage);
                    }
                }
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        block3: {
            block2: {
                super.messageSent(session, message);
                if (!(message instanceof byte[])) break block2;
                ByteMessage byteMessage = new ByteMessage();
                byteMessage.unpackMessage((byte[])message, byteMessage);
                String from = byteMessage.mFrom;
                String to = byteMessage.mTo;
                int id = byteMessage.mId;
                long timestamp = byteMessage.mTimestamp;
                byte[] messageByte = byteMessage.mMessage;
                Logger.d((String)TAG, (String)("byte[] messageSent: id=" + id + ";timestamp=" + timestamp + ";from=" + from + ";to=" + to));
                for (MobileMessageConnection connection : this.mMessageConnectionMap.values()) {
                    MessageConnection.MessageListener listener;
                    if (!to.equals(connection.getName()) || (listener = connection.getMessageListener()) == null) continue;
                    BufferMessage bufferMessage = new BufferMessage(timestamp, messageByte, id);
                    listener.onMessageSent((Message)bufferMessage);
                }
                break block3;
            }
            JSONObject json = new JSONObject(message.toString());
            if (!this.checkMessageSent(json)) break block3;
            String to = json.getString("to");
            String from = json.getString("from");
            String body = json.getString("msg_body");
            long timestamp = json.getLong("timestamp");
            int id = json.getInt("msg_id");
            Logger.d((String)TAG, (String)("String messageSent: id=" + id + ";timestamp=" + timestamp + ";from=" + from + ";to=" + to));
            for (MobileMessageConnection connection : this.mMessageConnectionMap.values()) {
                MessageConnection.MessageListener listener;
                if (!to.equals(connection.getName()) || (listener = connection.getMessageListener()) == null) continue;
                StringMessage stringMessage = new StringMessage(timestamp, body, id);
                listener.onMessageSent((Message)stringMessage);
            }
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        super.sessionOpened(session);
        Logger.d((String)TAG, (String)("Mobile sessionOpened:" + session));
        this.isSessionEnable = true;
        this.mIoSession = session;
        this.mSessionStateCallback.onSessionOpened(session);
        this.mConnectionInfo.setIoSession(session);
        session.write((Object)this.setSessionOpenMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession session) throws Exception {
        Logger.w((String)TAG, (String)("Mobile sessionClosed: " + session));
        super.sessionClosed(session);
        this.isSessionEnable = false;
        this.mSessionStateCallback.onSessionClosed();
        for (MobileMessageConnection connection : this.mMessageConnectionMap.values()) {
            connection.getConnectionStateListener().onClosed("The IO session is closed.");
        }
        this.mMessageConnectionMap.clear();
        List<ConnectionReadyInfo> list = this.mConnectionsReadyInfo;
        synchronized (list) {
            this.mConnectionsReadyInfo.clear();
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        super.sessionIdle(session, status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        super.exceptionCaught(session, cause);
        Logger.e((String)TAG, (String)"Mobile exceptionCaught: ", (Throwable)cause);
        throw MobileException.getIoSessionException("IoSession exception!", cause);
    }

    public boolean isConnected() {
        return this.isSessionEnable;
    }

    public void sendMessage(String message) {
        this.mIoSession.write((Object)message);
    }

    public void sendMessage(byte[] message) {
        this.mIoSession.write((Object)message);
    }

    public void setSessionChangedCallback(SessionStateCallback callback) {
        this.mSessionStateCallback = callback;
    }

    public void setMessageConnectionListener(MessageRouter.MessageConnectionListener listener) {
        this.mMessageConnectionListener = listener;
    }

    public void removeMessageConnectionListener() {
        this.mMessageConnectionListener = null;
    }

    public void setMetaData(String packageName, Set set) {
        Logger.d((String)TAG, (String)("setMetaData: name=" + packageName + "set =" + set.toString()));
        this.mConnectionInfo.setPackageName(packageName);
        this.mConnectionInfo.setMetadata(set);
    }

    private String setSessionOpenMessage() {
        JSONObject json = new JSONObject();
        try {
            json.put("from", (Object)this.mConnectionInfo.getPackageName());
            json.put("ACTION.SESSION_OPEN", (Object)MessageUtil.packSetToString((Set)this.mConnectionInfo.getMetadata()));
        }
        catch (JSONException e) {
            try {
                throw MobileException.getJsonException(e.getMessage(), e);
            }
            catch (MobileException mobileException) {
                Logger.e((String)TAG, (String)("setSessionMessage: " + mobileException.getMessage()));
            }
        }
        return json.toString();
    }

    public void setListenersReady(String from, String to, MessageConnection.ConnectionStateListener connectionStateListener, MessageConnection.MessageListener messageListener) {
        Logger.d((String)TAG, (String)("setListenersReady() called with: from = [" + from + "], to = [" + to + "]"));
        ConnectionReadyInfo info = new ConnectionReadyInfo(from, to, connectionStateListener, messageListener);
        this.mConnectionsReadyInfo.add(info);
        this.sendListenerReadyInfo(from, to);
    }

    private void sendListenerReadyInfo(String packageName, String to) {
        if (this.isConnected()) {
            JSONObject object = new JSONObject();
            try {
                object.put("timestamp", MessageUtil.getTimestamp());
                object.put("from", (Object)packageName);
                object.put("ACTION.MESSAGE_LISTENER_READY", (Object)to);
            }
            catch (JSONException e) {
                Logger.e((String)TAG, (String)"Message is not json", (Throwable)e);
            }
            this.mConnectionInfo.getIoSession().write((Object)object.toString());
        }
    }

    private boolean checkMessageSent(JSONObject json) {
        return !json.has(MOBILE_HEARTBEAT) && !json.has("ACTION.ADD_NEW") && !json.has("ACTION.UPDATE_ROBOT_LIST") && !json.has("ACTION.REMOVE_HOST") && !json.has("ACTION.REMOVE_DEAD") && !json.has("ACTION.MESSAGE_LISTENER_READY") && !json.has("ACTION.SESSION_OPEN");
    }
}

