package com.segway.robot.mobile.sdk.connectivity;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;

import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.keepalive.KeepAliveMessageFactory;

/**
 * Created by gaofeng on 2016/4/29.
 */
public class MobileKeepAliveImpl implements KeepAliveMessageFactory {
    private static final String TAG = "MobileKeepAliveImpl";
    private static final boolean DEBUG = false;

    @Override
    public boolean isRequest(IoSession ioSession, Object msg) {
        if (DEBUG) {
            Logger.d(TAG, "timestamp=" + MessageUtil.getTimestamp() + ">>>isRequest: " + ioSession + " message:" + msg);
        }
        return MessageUtil.ROBOT_HEARTBEAT_REQUEST.equals(msg.toString());
    }

    @Override
    public boolean isResponse(IoSession ioSession, Object msg) {
        if (DEBUG) {
            Logger.d(TAG, "timestamp=" + MessageUtil.getTimestamp() + ">>>isResponse: " + ioSession + " message:" + msg);
        }
        return MessageUtil.ROBOT_HEARTBEAT_RESPONSE.equals(msg.toString());
    }

    @Override
    public Object getRequest(IoSession ioSession) {
        if (DEBUG) {
            Logger.d(TAG, "timestamp=" + MessageUtil.getTimestamp() + ">>>getRequest: " + ioSession);
        }
        return MessageUtil.MOBILE_HEARTBEAT_REQUEST;
    }

    @Override
    public Object getResponse(IoSession ioSession, Object msg) {
        if (DEBUG) {
            Logger.d(TAG, "timestamp=" + MessageUtil.getTimestamp() + ">>>getResponse: " + ioSession + " message: " + msg);
        }
        return MessageUtil.MOBILE_HEARTBEAT_RESPONSE;
    }
}