/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.mobile.sdk.connectivity;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import com.segway.robot.mobile.sdk.connectivity.BufferMessage;
import com.segway.robot.mobile.sdk.connectivity.MobileException;
import com.segway.robot.mobile.sdk.connectivity.MobileKeepAliveImpl;
import com.segway.robot.mobile.sdk.connectivity.MobileMessageHandler;
import com.segway.robot.mobile.sdk.connectivity.SessionStateCallback;
import com.segway.robot.mobile.sdk.connectivity.StringMessage;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.baseconnectivity.ByteMessage;
import com.segway.robot.sdk.baseconnectivity.MessageConnection;
import com.segway.robot.sdk.baseconnectivity.MessageRouter;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.keepalive.KeepAliveFilter;
import org.apache.mina.filter.keepalive.KeepAliveMessageFactory;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.json.JSONException;
import org.json.JSONObject;

public class MobileMessageSocket
implements Handler.Callback {
    private static final String TAG = "MobileMessageSocket";
    private MobileMessageHandler mMobileMessageHandler = null;
    private NioSocketConnector mConnector = null;
    private IoSession mIoSession = null;
    private String mPackageName = null;
    private String mIp = null;
    private HandlerThread mHandlerThread = null;
    private Handler mHandler = null;
    private boolean isSessionOpened = false;
    private final AtomicBoolean isConnectionFinished = new AtomicBoolean(false);
    private ServiceBinder.BindStateListener mBindStateListener = null;
    private boolean isRepeatedConnect = false;
    private static final int PORT = 7798;
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int CONNECT = 1;
    private static final int DISCONNECT = 2;
    private SessionStateCallback mSessionStateCallback = new SessionStateCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionClosed() {
            AtomicBoolean atomicBoolean = MobileMessageSocket.this.isConnectionFinished;
            synchronized (atomicBoolean) {
                MobileMessageSocket.this.mIoSession = null;
                MobileMessageSocket.this.isSessionOpened = false;
                if (MobileMessageSocket.this.isRepeatedConnect) {
                    MobileMessageSocket.this.mBindStateListener.onUnbind("The robot has been connected with the other mobile!");
                } else {
                    MobileMessageSocket.this.mBindStateListener.onUnbind("The IO session is closed.");
                }
                MobileMessageSocket.this.isConnectionFinished.set(false);
                MobileMessageSocket.this.isConnectionFinished.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionOpened(IoSession ioSession) {
            AtomicBoolean atomicBoolean = MobileMessageSocket.this.isConnectionFinished;
            synchronized (atomicBoolean) {
                MobileMessageSocket.this.isSessionOpened = true;
                MobileMessageSocket.this.isRepeatedConnect = false;
                MobileMessageSocket.this.mBindStateListener.onBind();
                MobileMessageSocket.this.mHandler.removeMessages(1, (Object)MobileMessageSocket.this.mIp);
                MobileMessageSocket.this.mIoSession = ioSession;
                MobileMessageSocket.this.isConnectionFinished.set(true);
                MobileMessageSocket.this.isConnectionFinished.notifyAll();
            }
        }

        @Override
        public void onSessionRepeated(IoSession ioSession) {
            MobileMessageSocket.this.isRepeatedConnect = true;
            ioSession.closeNow();
        }
    };

    protected MobileMessageSocket() {
        Log.d((String)TAG, (String)"MobileMessageSocket: init");
        this.mMobileMessageHandler = new MobileMessageHandler();
        this.mHandlerThread = new HandlerThread("ConnectThread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), (Handler.Callback)this);
        this.mConnector = new NioSocketConnector();
        ObjectSerializationCodecFactory codecFactory = new ObjectSerializationCodecFactory();
        codecFactory.setDecoderMaxObjectSize(0x200000);
        codecFactory.setEncoderMaxObjectSize(0x200000);
        this.mConnector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)codecFactory));
        MobileKeepAliveImpl heartBeatFactory = new MobileKeepAliveImpl();
        KeepAliveFilter heartBeatFilter = new KeepAliveFilter((KeepAliveMessageFactory)heartBeatFactory, IdleStatus.BOTH_IDLE);
        heartBeatFilter.setForwardEvent(true);
        heartBeatFilter.setRequestInterval(5);
        heartBeatFilter.setRequestTimeout(2);
        this.mConnector.getFilterChain().addLast("heart", (IoFilter)heartBeatFilter);
        this.mConnector.setConnectTimeoutMillis(5000L);
        this.mConnector.getSessionConfig().setWriteTimeout(2);
        this.mConnector.setHandler((IoHandler)this.mMobileMessageHandler);
        this.setSessionStateChange(this.mSessionStateCallback);
    }

    protected synchronized void disconnect() {
        this.mHandler.removeMessages(1, (Object)this.mIp);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        Log.d((String)TAG, (String)("handleMessage() called with: msg = [" + msg + "]"));
        switch (msg.what) {
            case 1: {
                AtomicBoolean atomicBoolean = this.isConnectionFinished;
                synchronized (atomicBoolean) {
                    if (this.isSessionOpened || this.mIoSession != null) {
                        this.mHandler.removeMessages(1, (Object)this.mIp);
                        return true;
                    }
                    ConnectFuture future = this.mConnector.connect((SocketAddress)new InetSocketAddress(msg.obj.toString(), 7798));
                    future.awaitUninterruptibly();
                    if (future.getException() != null) {
                        Log.e((String)TAG, (String)"handleMessage, connect exception: ", (Throwable)future.getException());
                        this.isConnectionFinished.set(true);
                        this.isConnectionFinished.notifyAll();
                    }
                    break;
                }
            }
            case 2: {
                AtomicBoolean atomicBoolean = this.isConnectionFinished;
                synchronized (atomicBoolean) {
                    this.mHandler.removeMessages(1, (Object)this.mIp);
                    if (!this.mConnector.isDisposed() && this.mIoSession != null) {
                        this.mIoSession.getCloseFuture().awaitUninterruptibly(100L);
                        this.isSessionOpened = false;
                        try {
                            this.mMobileMessageHandler.inputClosed(this.mIoSession);
                        }
                        catch (Exception e) {
                            Log.e((String)TAG, (String)"handleMessage: Get Exception: ", (Throwable)e);
                        }
                        this.mIoSession = null;
                        this.mConnector.dispose();
                    }
                    this.mMobileMessageHandler = null;
                    this.mHandler = null;
                    this.mHandlerThread.quit();
                    this.mHandlerThread = null;
                    this.isConnectionFinished.set(true);
                    this.isConnectionFinished.notifyAll();
                    break;
                }
            }
        }
        return true;
    }

    protected synchronized void initSocketClient(String packageName, String ip, ServiceBinder.BindStateListener listener) {
        if (this.mConnector == null) {
            throw new NullPointerException("Connector is null pointer!");
        }
        this.mIp = ip;
        this.mPackageName = packageName;
        this.mBindStateListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean connect() {
        if (this.isSessionOpened || this.mIoSession != null) {
            return true;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)this.mIp));
        AtomicBoolean atomicBoolean = this.isConnectionFinished;
        synchronized (atomicBoolean) {
            while (!this.isConnectionFinished.get()) {
                try {
                    this.isConnectionFinished.wait(500L);
                }
                catch (InterruptedException e) {
                    Log.e((String)TAG, (String)"connect: Get InterruptedException: ", (Throwable)e);
                }
            }
        }
        this.isConnectionFinished.set(false);
        return this.isSessionOpened;
    }

    protected boolean isConnected() {
        return this.mMobileMessageHandler != null && this.mMobileMessageHandler.isConnected();
    }

    protected void sendMessage(String to, StringMessage body) throws MobileException {
        JSONObject jsonMessage = new JSONObject();
        try {
            jsonMessage.put("msg_id", body.getId());
            jsonMessage.put("timestamp", MessageUtil.getTimestamp());
            jsonMessage.put("from", (Object)this.mPackageName);
            jsonMessage.put("to", (Object)to);
            jsonMessage.put("msg_body", (Object)body.getContent());
        }
        catch (JSONException e) {
            throw MobileException.getJsonException(e.getMessage(), e);
        }
        if (this.mMobileMessageHandler != null && this.mConnector != null) {
            this.mMobileMessageHandler.sendMessage(jsonMessage.toString(), to);
        }
    }

    protected void sendMessage(String to, BufferMessage body) throws MobileException {
        Log.d((String)TAG, (String)("sendMessage() called with: to = [" + to + "], body = [" + "id=" + body.getId() + "]"));
        ByteMessage byteMessage = new ByteMessage(body.getId(), MessageUtil.getTimestamp(), this.mPackageName, to, body.getContent());
        byte[] bufferMessage = byteMessage.packByteMessage(byteMessage);
        if (this.mMobileMessageHandler != null && this.mConnector != null) {
            this.mMobileMessageHandler.sendMessage(bufferMessage, to);
        }
    }

    private void setSessionStateChange(SessionStateCallback callback) {
        this.mMobileMessageHandler.setSessionChangedCallback(callback);
    }

    protected void setConnectionListener(MessageRouter.MessageConnectionListener listener) {
        this.mMobileMessageHandler.setMessageConnectionListener(listener);
    }

    protected void removeConnectionListener() {
        this.mMobileMessageHandler.removeMessageConnectionListener();
    }

    protected void setMetaData(String packageName, Set set) {
        this.mMobileMessageHandler.setMetaData(packageName, set);
    }

    protected void setListenersReady(String from, String to, MessageConnection.ConnectionStateListener connectionStateListener, MessageConnection.MessageListener messageListener) {
        this.mMobileMessageHandler.setListenersReady(from, to, connectionStateListener, messageListener);
    }
}

