package com.segway.robot.mobile.sdk.connectivity;

/**
 * Thrown when a method is invoked with an exception which it cannot deal with.
 */
public class MobileException extends Exception {

    /**
     * Construct a new {@code MobileException} with the current stack trace
     * and the specified cause.
     *
     * @param throwable the cause of the exception.
     */
    public MobileException(Throwable throwable) {
        super(throwable);
    }

    /**
     * Construct a new {@code MobileException} with the current stack trace
     * and the specified detailed message.
     *
     * @param detailMessage the detailed message of the exception.
     */
    public MobileException(String detailMessage) {
        super(detailMessage);
    }

    /**
     * Construct a new {@code MobileException} with the current stack trace,
     * the specified detailed message, and the cause of the exception.
     *
     * @param detailMessage the detailed message of the exception.
     * @param throwable     the cause of the exception.
     */
    public MobileException(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
    }

    /**
     * This exception is thrown when an IO session exception occurs.
     *
     * @param detailMessage the detailed message of the exception.
     * @param throwable     the cause of the exception.
     * @return MobileException.
     */
    public static MobileException getIoSessionException(String detailMessage, Throwable throwable) {
        return new MobileException(detailMessage, throwable);
    }

    /**
     * This exception is thrown when a given package, application, or component
     * name cannot be found.
     *
     * @param detailMessage the detailed information of the exception.
     * @param throwable     the cause of this exception.
     * @return MobileException.
     */
    public static MobileException getPackageNameNotFound(String detailMessage, Throwable throwable) {
        return new MobileException(detailMessage, throwable);
    }

    /**
     * This exception is thrown when an exception occurs.
     *
     * @param detailMessage the detailed information of the exception.
     * @param throwable     the cause of this exception.
     * @return MobileException.
     */
    public static MobileException getException(String detailMessage, Throwable throwable) {
        return new MobileException(detailMessage, throwable);
    }

    /**
     * This exception is thrown when a JSON exception occurs.
     *
     * @param detailMessage the detailed information of the exception.
     * @param throwable     the cause of this exception.
     * @return MobileException.
     */
    public static MobileException getJsonException(String detailMessage, Throwable throwable) {
        return new MobileException(detailMessage, throwable);
    }

    /**
     * This exception is thrown when the sent message is longer than limited，
     * for BufferMessage is 1024*1000 and for StringMessage is 450*1024.
     *
     * @param detailMessage the detailed information of the exception.
     * @return MobileException.
     */
    public static MobileException getMessageTooLongException(String detailMessage) {
        return new MobileException(detailMessage);
    }

    /**
     * This exception is thrown when send message to the disconnected robot device.
     *
     * @param detailMessage the detailed information of the exception.
     * @return MobileException.
     */
    public static MobileException getNotConnectedException(String detailMessage) {
        return new MobileException(detailMessage);
    }

    /**
     * This exception is thrown when send message to the closed {@link MobileMessageConnection}.
     *
     * @param detailMessage the detailed information of the exception.
     * @return MobileException.
     */
    public static MobileException getMessageConnectionClosedException(String detailMessage) {
        return new MobileException(detailMessage);
    }
}