package com.segway.robot.algo.minicontroller;

import com.segway.robot.algo.Pose2D;

/**
 * Created by ark338 on 2017/3/17.
 */

public class VirtualMap {
    private Pose2D mOriginalOdometryPoint;

    public VirtualMap(Pose2D originalOdometryPoint) {
        mOriginalOdometryPoint = originalOdometryPoint;
    }

    public Pose2D mapToOdometry(float x, float y, float theta) {
        Pose2D pose2D = new Pose2D(x, y, theta, 0, 0, System.currentTimeMillis() * 1000);
        return mapToOdometry(pose2D);
    }

    public Pose2D mapToOdometry(Pose2D virtualPose) {
        double x,y,orient,angle;
        long timestamp;

        timestamp = virtualPose.getTimestamp();
        angle = diffAngle(mOriginalOdometryPoint.getTheta(), 0.0f);
        orient = plusAngle(virtualPose.getTheta(), angle);
        x = mOriginalOdometryPoint.getX()
                + virtualPose.getX() * Math.cos(angle)
                - virtualPose.getY() * Math.sin(angle);
        y = mOriginalOdometryPoint.getY()
                + virtualPose.getX() * Math.sin(angle)
                + virtualPose.getY() * Math.cos(angle);

        return new Pose2D((float)x, (float)y, (float) orient, 0, 0, timestamp);
    }

    public Pose2D mapToVirtual(float x, float y, float theta) {
        Pose2D pose2D = new Pose2D(x, y, theta, 0, 0, System.currentTimeMillis() * 1000);
        return mapToVirtual(pose2D);
    }

    public Pose2D mapToVirtual(Pose2D odometryPose) {
        double x,y,orient,angle;
        long timestamp;

        timestamp = odometryPose.getTimestamp();
        angle = diffAngle(0.0f, mOriginalOdometryPoint.getTheta());
        orient = diffAngle(angle, odometryPose.getTheta());
        x = -mOriginalOdometryPoint.getX()
                + odometryPose.getX() * Math.cos(angle)
                - odometryPose.getY() * Math.sin(angle);
        y = -mOriginalOdometryPoint.getY()
                + odometryPose.getX() * Math.sin(angle)
                + odometryPose.getY() * Math.cos(angle);

        return new Pose2D((float)x, (float)y, (float) orient, 0, 0, timestamp);
    }

    private double diffAngle(double from, double to) {
        double angle = from - to;
        if (angle > Math.PI) {
            angle = 2 * Math.PI - angle;
        }

        if (angle < -Math.PI) {
            angle = 2 * Math.PI + angle;
        }

        return (float)angle;
    }

    private double plusAngle(double from, double to) {
        double angle = from + to;
        if (angle > Math.PI) {
            angle = 2 * Math.PI - angle;
        }

        if (angle < -Math.PI) {
            angle = 2 * Math.PI + angle;
        }

        return (float)angle;
    }
}
