package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Point3DF describe a point in the world at a certain time
 */

public class Point3DF extends Point2DF {
    protected float mZ;

    public Point3DF(float x, float y, float z, long timeStamp) {
        super(x, y, timeStamp);
        mZ = z;
    }

    /**
     * Get the Z coordinate of the point
     * @return Z coordinate of the point
     */
    public float getZ() {
        return mZ;
    }

    public static final Parcelable.Creator<Point3DF> CREATOR = new Parcelable.Creator<Point3DF>() {
        @Override
        public Point3DF createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            float x = in.readFloat();
            float y = in.readFloat();
            float z = in.readFloat();
            return new Point3DF(x, y, z, timestamp);
        }

        @Override
        public Point3DF[] newArray(int size) {
            return new Point3DF[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimeStamp);
        dest.writeFloat(mX);
        dest.writeFloat(mY);
        dest.writeFloat(mZ);
    }

    @Override
    public String toString() {
        return "Point3DF{" +
                "mZ=" + mZ +
                '}';
    }
}
