/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.Pose2D;

public class PoseVLS
extends Pose2D {
    private final float mUncertaintyInPercentage;
    private final int mVIOQuality;
    private final float mPathLengthSinceStart;
    private final float mPathLengthSinceLastRelocation;
    public static final Parcelable.Creator<PoseVLS> CREATOR = new Parcelable.Creator<PoseVLS>(){

        public PoseVLS createFromParcel(Parcel in) {
            float x = in.readFloat();
            float y = in.readFloat();
            float theta = in.readFloat();
            float linearVelocity = in.readFloat();
            float angularVelocity = in.readFloat();
            float uncertainty = in.readFloat();
            int vio_quality = in.readInt();
            float pathLengthSinceStart = in.readFloat();
            float pathLengthSinceLastRelocation = in.readFloat();
            long timeStamp = in.readLong();
            return new PoseVLS(x, y, theta, linearVelocity, angularVelocity, uncertainty, vio_quality, pathLengthSinceStart, pathLengthSinceLastRelocation, timeStamp);
        }

        public PoseVLS[] newArray(int size) {
            return new PoseVLS[size];
        }
    };

    public PoseVLS(float x, float y, float theta, float linearVelocity, float angularVelocity, float uncertainty, int vio_quality, float pathLengthSinceStart, float pathLengthSinceLastRelocation, long timeStamp) {
        super(x, y, theta, linearVelocity, angularVelocity, timeStamp);
        this.mUncertaintyInPercentage = uncertainty;
        this.mVIOQuality = vio_quality;
        this.mPathLengthSinceStart = pathLengthSinceStart;
        this.mPathLengthSinceLastRelocation = pathLengthSinceLastRelocation;
    }

    public float getUncertaintyInPercentage() {
        return this.mUncertaintyInPercentage;
    }

    public float getVIOQuality() {
        return this.mVIOQuality;
    }

    public float getPathLengthSinceStart() {
        return this.mPathLengthSinceStart;
    }

    public float getPathLengthSinceLastRelocation() {
        return this.mPathLengthSinceLastRelocation;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.mX);
        dest.writeFloat(this.mY);
        dest.writeFloat(this.getTheta());
        dest.writeFloat(this.getLinearVelocity());
        dest.writeFloat(this.getAngularVelocity());
        dest.writeFloat(this.mUncertaintyInPercentage);
        dest.writeInt(this.mVIOQuality);
        dest.writeFloat(this.mPathLengthSinceStart);
        dest.writeFloat(this.mPathLengthSinceLastRelocation);
        dest.writeLong(this.mTimeStamp);
    }
}

