package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by ark338 on 2016/12/28.
 */

public class PoseVLS extends Pose2D {
    private final float mUncertaintyInPercentage;
    // quality: -1, 0: fail, 1: low, 2:medium, 3:high.
    // Note the quality might fall to low or fail when robot is moving rapidly, however the output pose might still be valid.
    // if the quality remains failed even when robot is static, then it is abnormal, and is recommended to restart VLS
    private final int mVIOQuality;
    private final float mPathLengthSinceStart;
    private final float mPathLengthSinceLastRelocation;

    public PoseVLS(float x, float y, float theta, float linearVelocity, float angularVelocity,
                   float uncertainty, int vio_quality, float pathLengthSinceStart,
                   float pathLengthSinceLastRelocation, long timeStamp) {
        super(x, y, theta, linearVelocity, angularVelocity, timeStamp);
        mUncertaintyInPercentage = uncertainty;
        mVIOQuality = vio_quality;
        mPathLengthSinceStart = pathLengthSinceStart;
        mPathLengthSinceLastRelocation = pathLengthSinceLastRelocation;
    }

    public float getUncertaintyInPercentage() {
        return mUncertaintyInPercentage;
    }

    public float getVIOQuality() {
        return mVIOQuality;
    }

    public float getPathLengthSinceStart() {
        return mPathLengthSinceStart;
    }

    public float getPathLengthSinceLastRelocation() {
        return mPathLengthSinceLastRelocation;
    }

    public static final Parcelable.Creator<PoseVLS> CREATOR = new Parcelable.Creator<PoseVLS>() {
        @Override
        public PoseVLS createFromParcel(Parcel in) {
            float x = in.readFloat();
            float y = in.readFloat();
            float theta = in.readFloat();
            float linearVelocity = in.readFloat();
            float angularVelocity = in.readFloat();
            float uncertainty = in.readFloat();
            int vio_quality = in.readInt();
            float pathLengthSinceStart = in.readFloat();
            float pathLengthSinceLastRelocation = in.readFloat();
            long timeStamp = in.readLong();
            return new PoseVLS(x, y, theta, linearVelocity, angularVelocity, uncertainty,
                    vio_quality, pathLengthSinceStart, pathLengthSinceLastRelocation, timeStamp);
        }

        @Override
        public PoseVLS[] newArray(int size) {
            return new PoseVLS[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(mX);
        dest.writeFloat(mY);
        dest.writeFloat(getTheta());
        dest.writeFloat(getLinearVelocity());
        dest.writeFloat(getAngularVelocity());
        dest.writeFloat(mUncertaintyInPercentage);
        dest.writeInt(mVIOQuality);
        dest.writeFloat(mPathLengthSinceStart);
        dest.writeFloat(mPathLengthSinceLastRelocation);
        dest.writeLong(mTimeStamp);
    }
}
