package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

/**
 * Created by tangchu on 2017/1/13.
 */

public class RelativePoint2DF implements StampedData, Parcelable{
    private final long mTimeStamp;
    private final float mDistance;
    private final float mTheta;

    public RelativePoint2DF(float distance, float theta, long timestamp) {
        this.mDistance = distance;
        this.mTheta = theta;
        this.mTimeStamp = timestamp;
    }

    protected RelativePoint2DF(Parcel in) {
        mTimeStamp = in.readLong();
        mDistance = in.readFloat();
        mTheta = in.readFloat();
    }

    public static final Creator<RelativePoint2DF> CREATOR = new Creator<RelativePoint2DF>() {
        @Override
        public RelativePoint2DF createFromParcel(Parcel in) {
            return new RelativePoint2DF(in);
        }

        @Override
        public RelativePoint2DF[] newArray(int size) {
            return new RelativePoint2DF[size];
        }
    };

    public float getmDistance() {
        return mDistance;
    }

    public float getmTheta() {
        return mTheta;
    }

    @Override
    public long getTimestamp() {
        return mTimeStamp;
    }

    @Override
    public long diff(StampedData source) {
        if (source == null) {
            throw new IllegalArgumentException("diff source is null");
        }
        return source.getTimestamp() - getTimestamp();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimeStamp);
        dest.writeFloat(mDistance);
        dest.writeFloat(mTheta);
    }

    @Override
    public String toString() {
        return "RelativePoint2DF{" +
                "mTimeStamp=" + mTimeStamp +
                ", mDistance=" + mDistance +
                ", mTheta=" + mTheta +
                '}';
    }
}
