/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo.dts;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.CubeF;
import com.segway.robot.algo.Pose2D;
import com.segway.robot.algo.dts.Person;

public class DTSPerson
extends Person {
    private int mType;
    private float mConfidence;
    private Rect mDrawingRect;
    private Pose2D mRobotPose;
    private float mTheta;
    private float mPitch;
    private float mDistance;
    private int mPoseRecognitionIdx;
    private float mPoseRecognitionScore;
    public static final Parcelable.Creator<DTSPerson> CREATOR = new Parcelable.Creator<DTSPerson>(){

        public DTSPerson createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            float x = in.readFloat();
            float y = in.readFloat();
            float z = in.readFloat();
            CubeF cubeF = (CubeF)in.readParcelable(CubeF.class.getClassLoader());
            int id = in.readInt();
            int type = in.readInt();
            float confidence = in.readFloat();
            Rect rect = (Rect)in.readParcelable(Rect.class.getClassLoader());
            Pose2D pose = (Pose2D)in.readParcelable(Pose2D.class.getClassLoader());
            float theta = in.readFloat();
            float pitch = in.readFloat();
            float distance = in.readFloat();
            int recId = in.readInt();
            float score = in.readFloat();
            return new DTSPerson(x, y, z, cubeF, id, type, confidence, rect, pose, theta, pitch, distance, timestamp, recId, score);
        }

        public DTSPerson[] newArray(int size) {
            return new DTSPerson[size];
        }
    };

    public DTSPerson(float x, float y, float z, CubeF bound, int id, int type, float confidence, Rect drawingRect, Pose2D robotPose, float theta, float pitch, float distance, long timeStamp, int poseRecognitionIdx, float poseRecognitionScore) {
        super(x, y, z, bound, id, timeStamp);
        this.mType = type;
        this.mConfidence = confidence;
        this.mDrawingRect = drawingRect;
        this.mRobotPose = robotPose;
        this.mTheta = theta;
        this.mPitch = pitch;
        this.mDistance = distance;
        this.mPoseRecognitionIdx = poseRecognitionIdx;
        this.mPoseRecognitionScore = poseRecognitionScore;
    }

    public DTSPerson(float x, float y, float z, CubeF bound, int id, int type, float confidence, Rect drawingRect, Pose2D robotPose, float theta, float pitch, float distance, long timeStamp) {
        super(x, y, z, bound, id, timeStamp);
        this.mType = type;
        this.mConfidence = confidence;
        this.mDrawingRect = drawingRect;
        this.mRobotPose = robotPose;
        this.mTheta = theta;
        this.mPitch = pitch;
        this.mDistance = distance;
        this.mPoseRecognitionIdx = -1;
        this.mPoseRecognitionScore = -1.0f;
    }

    public DTSPerson(DTSPerson person) {
        super(person.getX(), person.getY(), person.getZ(), person.getBound(), person.getId(), person.getTimestamp());
        this.mType = person.getType();
        this.mConfidence = person.getConfidence();
        this.mDrawingRect = person.getDrawingRect();
        this.mRobotPose = person.getRobotPose();
        this.mTheta = person.getTheta();
        this.mPitch = person.getPitch();
        this.mDistance = person.getDistance();
        this.mPoseRecognitionIdx = person.getPoseRecognitionIndex();
        this.mPoseRecognitionScore = person.getPoseRecognitionScore();
    }

    public int getType() {
        return this.mType;
    }

    public float getConfidence() {
        return this.mConfidence;
    }

    public Rect getDrawingRect() {
        return this.mDrawingRect;
    }

    public Pose2D getRobotPose() {
        return this.mRobotPose;
    }

    public float getTheta() {
        return this.mTheta;
    }

    public float getPitch() {
        return this.mPitch;
    }

    public float getDistance() {
        return this.mDistance;
    }

    public int getPoseRecognitionIndex() {
        return this.mPoseRecognitionIdx;
    }

    public float getPoseRecognitionScore() {
        return this.mPoseRecognitionScore;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStamp);
        dest.writeFloat(this.mX);
        dest.writeFloat(this.mY);
        dest.writeFloat(this.mZ);
        dest.writeParcelable((Parcelable)this.mBound, flags);
        dest.writeInt(this.mId);
        dest.writeInt(this.mType);
        dest.writeFloat(this.mConfidence);
        dest.writeParcelable((Parcelable)this.mDrawingRect, flags);
        dest.writeParcelable((Parcelable)this.mRobotPose, flags);
        dest.writeFloat(this.mTheta);
        dest.writeFloat(this.mPitch);
        dest.writeFloat(this.mDistance);
        dest.writeInt(this.mPoseRecognitionIdx);
        dest.writeFloat(this.mPoseRecognitionScore);
    }

    @Override
    public String toString() {
        return "DTSPerson{mZ=" + this.mZ + ", mBound=" + this.mBound + ", mTimeStamp=" + this.mTimeStamp + ", mId=" + this.mId + ", mType=" + this.mType + ", mX=" + this.mX + ", mConfidence=" + this.mConfidence + ", mY=" + this.mY + ", mDrawingRect=" + this.mDrawingRect + ", mRobotPose=" + this.mRobotPose + ", mTheta=" + this.mTheta + ", mPitch=" + this.mPitch + ", mDistance=" + this.mDistance + ", mPoseRecognitionIdx=" + this.mPoseRecognitionIdx + ", mPoseRecognitionScore=" + this.mPoseRecognitionScore + '}';
    }
}

