package com.segway.robot.algo.minicontroller;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.algo.Point2DF;
import com.segway.robot.sdk.base.time.StampedData;

public	class	Trajectory	implements StampedData, Parcelable {
    private	long	mTimeStamp;
    private	Point2DF[]	mTrajectory;
    public	Trajectory(Point2DF[]	trajectory,	long	timestamp)	{
        mTrajectory	=	trajectory;
        mTimeStamp	=	timestamp;
    }

    protected Trajectory(Parcel in) {
        mTimeStamp = in.readLong();
        mTrajectory = in.createTypedArray(Point2DF.CREATOR);
    }

    public static final Creator<Trajectory> CREATOR = new Creator<Trajectory>() {
        @Override
        public Trajectory createFromParcel(Parcel in) {
            return new Trajectory(in);
        }

        @Override
        public Trajectory[] newArray(int size) {
            return new Trajectory[size];
        }
    };

    public	long	getTimestamp()	{
        return	mTimeStamp;
    }

    @Override
    public long diff(StampedData source) {
        return 0;
    }

    public	Point2DF[]	getTrajectory()	{
        return	mTrajectory;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimeStamp);
        dest.writeTypedArray(mTrajectory, flags);
    }
}
